/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.beans.AppCtx;
import info.joseluismartin.dao.Page;
import info.joseluismartin.dao.PageChangedEvent;
import info.joseluismartin.dao.PageableDataSource;
import info.joseluismartin.dao.Paginator;
import info.joseluismartin.dao.PaginatorListener;
import info.joseluismartin.gui.ColumnDescriptor;
import info.joseluismartin.gui.Editor;
import info.joseluismartin.gui.EditorEvent;
import info.joseluismartin.gui.EditorListener;
import info.joseluismartin.gui.GuiFactory;
import info.joseluismartin.gui.ListTableModel;
import info.joseluismartin.gui.ModelRowSorter;
import info.joseluismartin.gui.PaginatorView;
import info.joseluismartin.gui.TableRowAction;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.VisibilityBox;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.gui.table.LoadPreferencesAction;
import info.joseluismartin.gui.table.SavePreferencesAction;
import info.joseluismartin.model.TableState;
import info.joseluismartin.service.TableService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageableTable
extends JPanel
implements RowSorterListener,
PaginatorListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PageableTable.class);
    private BorderLayout layout = new BorderLayout();
    private JTable table;
    private PaginatorView paginatorView;
    private Page<Object> page = new Page();
    private PageableDataSource<Object> dataSource;
    private ListTableModel tableModel;
    private JScrollPane tableScrollPane;
    private ModelRowSorter<ListTableModel> sorter;
    private Object filter;
    private List<ColumnDescriptor> columnDescriptors;
    private VisibilityBox visibilityBox;
    GuiFactory guiFactory;
    String editorName;
    private Map<Object, Window> openDialogs = Collections.synchronizedMap(new HashMap());
    private TableService tableService;
    private MessageSource messageSource = new ResourceBundleMessageSource();
    JMenuBar rightMenuBar;
    private Icon visibilityMenuIcon;
    private Icon okIcon;
    private Icon cancelIcon;
    private Icon userMenuIcon;
    private String sortPropertyName;
    private Page.Order order;

    public void init() {
        this.okIcon = FormUtils.getIcon(this.okIcon, "/images/16x16/dialog-ok.png");
        this.cancelIcon = FormUtils.getIcon(this.cancelIcon, "/images/16x16/dialog-cancel.png");
        this.visibilityMenuIcon = FormUtils.getIcon(this.visibilityMenuIcon, "/images/16x16/view-choose.png");
        this.userMenuIcon = FormUtils.getIcon(this.userMenuIcon, "/images/table/16x16/users.png");
        this.sorter = new ModelRowSorter<ListTableModel>(this.tableModel);
        this.sorter.addRowSorterListener(this);
        this.page.addPaginatorListener((PaginatorListener)this);
        this.paginatorView.setPaginator((Paginator)this.page);
        this.createColumnDescriptos();
        this.table = new JTable(this.tableModel, this.tableModel.getTableColumnModel());
        this.table.setAutoCreateRowSorter(false);
        this.table.setRowSorter(this.sorter);
        this.table.setRowHeight(22);
        this.table.addMouseListener(new TableListener());
        this.tableScrollPane = new JScrollPane(this.table);
        this.setLayout(this.layout);
        this.setBackground(Color.WHITE);
        this.add((Component)this.tableScrollPane, "Center");
        this.add((Component)this.paginatorView.getPanel(), "South");
        this.createMenu();
        this.page.firstPage();
        this.restoreState();
    }

    private void createMenu() {
        this.rightMenuBar = new JMenuBar();
        this.rightMenuBar.setLayout(new BoxLayout(this.rightMenuBar, 3));
        this.rightMenuBar.setMargin(new Insets(0, 0, 0, 0));
        JMenu menu = new JMenu();
        menu.setMargin(new Insets(0, 0, 0, 0));
        menu.setIcon(this.visibilityMenuIcon);
        menu.setMaximumSize(new Dimension(50, 50));
        this.visibilityBox = new VisibilityBox(this.columnDescriptors);
        menu.add(this.visibilityBox);
        menu.getPopupMenu().addPopupMenuListener(new VisibilityPopupListener());
        JMenuItem okMenuItem = new JMenuItem(new OkVisibilityAction());
        JMenuItem cancelMenuItem = new JMenuItem(new CancelVisibilityAction());
        menu.addSeparator();
        menu.add(okMenuItem);
        menu.add(cancelMenuItem);
        this.rightMenuBar.add(menu);
        JMenu prefsMenu = new JMenu();
        prefsMenu.setMargin(new Insets(0, 0, 0, 0));
        prefsMenu.setIcon(this.userMenuIcon);
        prefsMenu.setMaximumSize(new Dimension(50, 50));
        prefsMenu.add(new JMenuItem(new LoadPreferencesAction(this, this.messageSource.getMessage("PageableTable.loadPreferences", null, "Load Preferences", Locale.getDefault()))));
        prefsMenu.add(new JMenuItem(new SavePreferencesAction(this, this.messageSource.getMessage("PageableTable.savePreferences", null, "Save Preferences", Locale.getDefault()))));
        this.rightMenuBar.add(prefsMenu);
        this.rightMenuBar.add(Box.createVerticalGlue());
        this.add((Component)this.rightMenuBar, "East");
    }

    private void createColumnDescriptos() {
        this.columnDescriptors = new ArrayList<ColumnDescriptor>(this.tableModel.getPropertyCount());
        for (int i = 0; i < this.tableModel.getPropertyCount(); ++i) {
            this.columnDescriptors.add(new ColumnDescriptor(this.tableModel.getColumnNames().get(i), this.tableModel.getDisplayNames().get(i), true));
        }
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        if (this.sorter.getSortKeys().size() > 0 && this.tableModel.isPropertyColumn(this.sorter.getSortKeys().get(0).getColumn())) {
            this.page.firstPage();
        }
    }

    private Page.Order converSortOrder(RowSorter.SortKey key) {
        Page.Order order = Page.Order.ASC;
        if (key.getSortOrder() == SortOrder.DESCENDING) {
            order = Page.Order.DESC;
        }
        return order;
    }

    private void loadPage() {
        RowSorter.SortKey key;
        Page.Order order = Page.Order.ASC;
        String sortPropertyName = null;
        List<RowSorter.SortKey> keys = this.sorter.getSortKeys();
        if (keys.size() > 0 && this.tableModel.isPropertyColumn((key = this.sorter.getSortKeys().get(0)).getColumn())) {
            sortPropertyName = this.tableModel.getSortPropertyName(key.getColumn());
            order = this.converSortOrder(key);
        }
        this.page.setSortName(sortPropertyName);
        this.page.setOrder(order);
        this.page.setFilter(this.filter);
        this.dataSource.getPage(this.page);
        this.tableModel.setList(this.page.getData());
    }

    public void pageChanged(PageChangedEvent event) {
        this.loadPage();
        this.tableModel.setList(this.page.getData());
    }

    public Window getEditor() {
        Window dlg = (Window)this.guiFactory.getObject(this.editorName);
        return dlg;
    }

    public Window getEditor(Object toEdit) {
        Window dlg = this.openDialogs.get(toEdit);
        if (dlg == null) {
            dlg = this.getEditor();
            this.openDialogs.put(toEdit, dlg);
            ((View)((Object)dlg)).setModel(toEdit);
            ((View)((Object)dlg)).refresh();
            dlg.addWindowListener(new DialogWindowListener());
            if (dlg instanceof Editor) {
                ((Editor)((Object)dlg)).addEditorListener(new EditorListener(){

                    public void modelChanged(EditorEvent e) {
                        PageableTable.this.refresh();
                    }
                });
            }
        }
        return dlg;
    }

    public void restoreState() {
        TableState state;
        if (this.tableService != null && (state = this.tableService.getState(this.getName())) != null) {
            this.restoreState(state);
        }
    }

    public void restoreState(TableState state) {
        for (ColumnDescriptor cd : this.columnDescriptors) {
            cd.setVisible(state.getVisibleColumns().contains(cd.getPropertyName()));
        }
        this.paginatorView.getPaginator().setPageSize(state.getPageSize());
        this.updateVisibleColumns();
    }

    private void updateVisibleColumns() {
        ArrayList<String> displayNames = new ArrayList<String>(this.columnDescriptors.size());
        ArrayList<String> propertyNames = new ArrayList<String>(this.columnDescriptors.size());
        for (ColumnDescriptor cd : this.columnDescriptors) {
            if (!cd.isVisible()) continue;
            displayNames.add(cd.getDisplayName());
            propertyNames.add(cd.getPropertyName());
        }
        this.tableModel.setDisplayNames(displayNames);
        this.tableModel.setColumnNames(propertyNames);
        this.tableModel.init();
        this.table.setColumnModel(this.tableModel.getTableColumnModel());
        this.tableModel.fireTableChanged();
    }

    public void saveState() {
        if (this.tableService == null) {
            return;
        }
        TableState state = new TableState();
        ArrayList<String> visible = new ArrayList<String>();
        for (ColumnDescriptor cd : this.columnDescriptors) {
            if (!cd.isVisible()) continue;
            visible.add(cd.getPropertyName());
        }
        state.setName(this.getName());
        state.setVisibleColumns(visible);
        state.setPageSize(this.paginatorView.getPaginator().getPageSize());
        this.tableService.saveState(state);
    }

    public PaginatorView getPaginatorView() {
        return this.paginatorView;
    }

    public void setPaginatorView(PaginatorView paginatorView) {
        this.paginatorView = paginatorView;
    }

    public PageableDataSource<Object> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(PageableDataSource<Object> dataSource) {
        this.dataSource = dataSource;
    }

    public Paginator getPaginator() {
        return this.paginatorView.getPaginator();
    }

    public ListTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(ListTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public Icon getVisibilityMenuIcon() {
        return this.visibilityMenuIcon;
    }

    public void setVisibilityMenuIcon(Icon visibilityMenuIcon) {
        this.visibilityMenuIcon = visibilityMenuIcon;
    }

    public Icon getOkIcon() {
        return this.okIcon;
    }

    public void setOkIcon(Icon okIcon) {
        this.okIcon = okIcon;
    }

    public Icon getCancelIcon() {
        return this.cancelIcon;
    }

    public void setCancelIcon(Icon cancelIcon) {
        this.cancelIcon = cancelIcon;
    }

    public GuiFactory getGuiFactory() {
        return this.guiFactory;
    }

    public void setGuiFactory(GuiFactory guiFactory) {
        this.guiFactory = guiFactory;
    }

    public String getEditorName() {
        return this.editorName;
    }

    public void setEditorName(String editorName) {
        this.editorName = editorName;
    }

    public void refresh() {
        this.pageChanged(null);
    }

    public static void main(String[] args) {
        PageableTable incidencesTable = (PageableTable)AppCtx.getInstance().getBean("incidentTable");
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(incidencesTable);
        f.setSize(new Dimension(800, 600));
        f.setVisible(true);
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        this.filter = filter;
    }

    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
        this.table.setDefaultRenderer(columnClass, renderer);
    }

    public String getSortPropertyName() {
        return this.sortPropertyName;
    }

    public void setSortPropertyName(String sortPropertyName) {
        this.sortPropertyName = sortPropertyName;
    }

    public Page.Order getOrder() {
        return this.order;
    }

    public void setOrder(Page.Order order) {
        this.order = order;
    }

    public TableService getTableService() {
        return this.tableService;
    }

    public void setTableService(TableService tableService) {
        this.tableService = tableService;
    }

    public Icon getUserMenuIcon() {
        return this.userMenuIcon;
    }

    public void setUserMenuIcon(Icon userMenuIcon) {
        this.userMenuIcon = userMenuIcon;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private class DialogWindowListener
    extends WindowAdapter {
        private DialogWindowListener() {
        }

        public void windowClosed(WindowEvent e) {
            if (PageableTable.this.openDialogs.remove(((View)((Object)e.getWindow())).getModel()) == null) {
                log.warn((Object)"Tray to remove a non existant Dialog, \u00c2\u00bfmay be model hashcode changed?");
            }
        }
    }

    private class TableListener
    extends MouseAdapter {
        private TableListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Object toEdit;
            Window dlg;
            Point point = e.getPoint();
            int row = PageableTable.this.table.rowAtPoint(point);
            int col = PageableTable.this.table.columnAtPoint(point);
            if (col != -1 && row != -1 && PageableTable.this.tableModel.isActionColumn(col)) {
                TableRowAction action = (TableRowAction)PageableTable.this.tableModel.getValueAt(row, col);
                action.setTable(PageableTable.this);
                action.setRow(PageableTable.this.tableModel.getList().get(row));
                action.actionPerformed(new ActionEvent(this, 1001, "clicked"));
            }
            if (row != -1 && e.getClickCount() == 2 && (dlg = PageableTable.this.getEditor(toEdit = PageableTable.this.tableModel.getList().get(row))) != null) {
                if (dlg instanceof Frame) {
                    ((Frame)dlg).setState(0);
                    ((Frame)dlg).requestFocus();
                }
                dlg.setLocationRelativeTo(null);
                dlg.setAlwaysOnTop(true);
                dlg.setVisible(true);
            }
        }
    }

    class LoadUserPreferencesAction
    extends AbstractAction {
        LoadUserPreferencesAction() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class SaveUserPreferencesAction
    extends AbstractAction {
        SaveUserPreferencesAction() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class CancelVisibilityAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CancelVisibilityAction() {
            super("Cancelar", PageableTable.this.cancelIcon);
        }

        public void actionPerformed(ActionEvent e) {
            PageableTable.this.visibilityBox.setColumnDescriptors(PageableTable.this.columnDescriptors);
        }
    }

    class OkVisibilityAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OkVisibilityAction() {
            super("Aceptar", PageableTable.this.okIcon);
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < PageableTable.this.columnDescriptors.size(); ++i) {
                ColumnDescriptor cd = (ColumnDescriptor)PageableTable.this.columnDescriptors.get(i);
                cd.setVisible(PageableTable.this.visibilityBox.getColumnDescriptors().get(i).isVisible());
            }
            PageableTable.this.updateVisibleColumns();
        }
    }

    class VisibilityPopupListener
    implements PopupMenuListener {
        VisibilityPopupListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            PageableTable.this.visibilityBox.setColumnDescriptors(PageableTable.this.columnDescriptors);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            PageableTable.this.visibilityBox.setColumnDescriptors(PageableTable.this.columnDescriptors);
        }
    }
}

