/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.gui.PanelHolder;
import info.joseluismartin.gui.form.FormUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPane
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_TABLE_ICON = "/images/table/table.png";
    private List<PanelHolder> panels;
    private JList list = new JList();
    private Icon tableIcon;
    private JPanel editorPanel = new JPanel(new BorderLayout());
    private JSplitPane split;

    public void init() {
        this.setLayout(new BoxLayout(this, 2));
        this.tableIcon = FormUtils.getIcon(this.tableIcon, DEFAULT_TABLE_ICON);
        for (PanelHolder p : this.panels) {
            p.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        }
        this.list = new JList<Object>(this.panels.toArray());
        this.list.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(-1);
        this.list.addListSelectionListener(this);
        this.list.setCellRenderer(new ListCellRenderer());
        this.list.setSelectedIndex(0);
        JScrollPane scroll = new JScrollPane(this.list);
        this.split = new JSplitPane(1, scroll, this.editorPanel);
        this.split.setResizeWeight(0.0);
        this.split.setDividerLocation(150);
        this.add(this.split);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        PanelHolder panel = (PanelHolder)this.list.getSelectedValue();
        this.editorPanel.removeAll();
        this.editorPanel.add(panel.getPanel());
        this.editorPanel.revalidate();
        this.editorPanel.repaint();
    }

    public Icon getTableIcon() {
        return this.tableIcon;
    }

    public void setTableIcon(Icon tableIcon) {
        this.tableIcon = tableIcon;
    }

    public List<PanelHolder> getPanels() {
        return this.panels;
    }

    public void setPanels(List<PanelHolder> panels) {
        this.panels = panels;
    }

    class ListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        ListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            PanelHolder panel = (PanelHolder)value;
            this.setText(panel.getName());
            Icon icon = panel.getIcon() != null ? panel.getIcon() : ListPane.this.tableIcon;
            this.setIcon(icon);
            return this;
        }
    }
}

