/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;

class HighLightRowListener
extends MouseAdapter {
    private int highLightedRow = -1;
    Rectangle dirtyRegion = null;

    HighLightRowListener() {
    }

    public void mouseMoved(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        try {
            int row = table.rowAtPoint(e.getPoint());
            Graphics g = table.getGraphics();
            if (this.highLightedRow != row) {
                if (null != this.dirtyRegion) {
                    table.paintImmediately(this.dirtyRegion);
                }
                if (!table.getSelectionModel().isSelectedIndex(row)) {
                    for (int j = 0; j < table.getRowCount(); ++j) {
                        if (row != j) continue;
                        Rectangle firstRowRect = table.getCellRect(row, 0, false);
                        Rectangle lastRowRect = table.getCellRect(row, table.getColumnCount() - 1, false);
                        this.dirtyRegion = firstRowRect.union(lastRowRect);
                        g.setColor(new Color(255, 255, 0, 100));
                        g.fillRect((int)this.dirtyRegion.getX(), (int)this.dirtyRegion.getY(), (int)this.dirtyRegion.getWidth(), (int)this.dirtyRegion.getHeight());
                    }
                }
            }
            this.highLightedRow = row;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

