/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.dao.PageChangedEvent;
import info.joseluismartin.dao.Paginator;
import info.joseluismartin.dao.PaginatorListener;
import java.util.ArrayList;

public class DefaultPaginator
implements Paginator {
    private int totalRecords;
    private int page = 1;
    private int pageSize = 10;
    private ArrayList<PaginatorListener> listeners = new ArrayList();

    public int getCount() {
        return this.totalRecords;
    }

    public boolean hasNext() {
        return this.page < this.getTotalPages();
    }

    public boolean hasPage(int indexPage) {
        return indexPage <= this.getTotalPages() && indexPage > 0;
    }

    public boolean hasPrevious() {
        return this.page > 1;
    }

    public void setPage(int indexPage) {
        this.page = indexPage;
        this.firePageChangedEvent();
    }

    public int getStartIndex() {
        return (this.page - 1) * this.pageSize;
    }

    public int getTotalPages() {
        if (this.pageSize > 0) {
            return this.totalRecords / this.pageSize + (this.totalRecords % this.pageSize == 0 ? 0 : 1);
        }
        return 1;
    }

    public void addPaginatorListener(PaginatorListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePaginatorListener(PaginatorListener listener) {
        this.listeners.remove(listener);
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public void setCount(int totalRecords) {
        this.totalRecords = totalRecords;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize > 0) {
            this.page = (int)Math.ceil(this.getStartIndex() / pageSize) + 1;
            this.pageSize = pageSize;
            this.firePageChangedEvent();
        }
    }

    public int getPage() {
        return this.page;
    }

    public void firstPage() {
        this.setPage(1);
    }

    public void lastPage() {
        this.setPage(this.getTotalPages());
    }

    public void nextPage() {
        this.setPage(this.page + 1);
    }

    public void previousPage() {
        this.setPage(this.page - 1);
    }

    private void firePageChangedEvent() {
        for (PaginatorListener listener : this.listeners) {
            listener.pageChanged(new PageChangedEvent((Object)this, this.page, this.getStartIndex(), this.getTotalPages(), this.pageSize));
        }
    }
}

