/*
 * Copyright 2009-2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package info.joseluismartin.gui.bind;

/**
 * Generic ControlBinder that use a ControlAccessorFactory to get/set control values
 * 
 * @author Jose Luis Martin - (jlm@joseluismartin.info)
 * @since 1.1
 * @see info.joseluismartin.gui.Binder
 * @see info.joseluismartin.gui.bind.AbstractBinder
 */
public class ControlBinder extends AbstractBinder {
	
	private ControlAccessorFactory controlAccessorFactory;
	private ControlAccessor controlAccessor;
	
	public ControlBinder() {
		this(new ConfigurableControlAccessorFactory());
	}
	
	public ControlBinder(ControlAccessorFactory controlAccessorFactory) {
		this.controlAccessorFactory = controlAccessorFactory;
	}
	
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void doBind() {
		controlAccessor = controlAccessorFactory.getControlAccessor(component);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void doRefresh() {
		controlAccessor.setControlValue(getValue());
		
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void doUpdate() {
		setValue(controlAccessor.getControlValue());
		
	}

	/**
	 * @return the controlAccessorFactory
	 */
	public ControlAccessorFactory getControlAccessorFactory() {
		return controlAccessorFactory;
	}

	/**
	 * @param controlAccessorFactory the controlAccessorFactory to set
	 */
	public void setControlAccessorFactory(ControlAccessorFactory controlAccessorFactory) {
		this.controlAccessorFactory = controlAccessorFactory;
	}

	
}
