/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.SyncTaskExecutor;

public class DispatcherQueue<T> {
    private static final Log log = LogFactory.getLog(DispatcherQueue.class);
    private BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    private Thread dispatcherThread;
    private volatile boolean running = false;
    private Executor executor = new SyncTaskExecutor();
    private Dispatcher<T> dispatcher;

    public DispatcherQueue() {
    }

    public DispatcherQueue(Dispatcher<T> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void init() {
        this.start();
    }

    private void dispatch() {
        while (this.running) {
            Object t = null;
            try {
                t = this.queue.take();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dispatching object: " + t.toString()));
                }
                this.dispatcher.dispatch(t);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                break;
            }
            catch (Exception e) {
                log.error((Object)"Dispather failed. Readding object to queue again.");
                log.error((Object)e.getMessage());
                this.queue.offer(t);
            }
        }
    }

    protected Runnable createWorker(final T t) {
        return new Runnable(){

            @Override
            public void run() {
                DispatcherQueue.this.dispatch(t);
            }
        };
    }

    protected void dispatch(T t) {
        if (this.dispatcher != null) {
            try {
                this.dispatcher.dispatch(t);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        } else {
            log.error((Object)"Dispatcher is null, Override default dispatch method or configure a dispatcher.");
        }
    }

    public int size() {
        return this.queue.size();
    }

    public void put(T t) {
        try {
            this.queue.put(t);
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
    }

    public void clear() {
        this.queue.clear();
    }

    public void stop() {
        this.running = false;
        this.dispatcherThread.interrupt();
        try {
            this.dispatcherThread.join();
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
    }

    public void start() {
        if (this.running) {
            log.warn((Object)"Already running");
            return;
        }
        this.dispatcherThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DispatcherQueue.this.dispatch();
            }
        });
        this.running = true;
        log.info((Object)"Starting dispatcher thread");
        this.dispatcherThread.start();
    }

    public Dispatcher<T> getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher<T> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    public void setQueue(BlockingQueue<T> queue) {
        this.queue = queue;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public static interface Dispatcher<T> {
        public void dispatch(T var1);
    }
}

