/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.util.comparator;

import java.util.Comparator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.util.comparator.AlphaNumericComparator;

public class PropertyComparator
implements Comparator<Object> {
    private static Log log = LogFactory.getLog(PropertyComparator.class);
    private String name;
    private Comparator<String> comparator = new AlphaNumericComparator();

    public PropertyComparator(String name) {
        this.name = name;
    }

    @Override
    public int compare(Object o1, Object o2) {
        try {
            String value1 = BeanUtils.getProperty((Object)o1, (String)this.name).trim();
            String value2 = BeanUtils.getProperty((Object)o2, (String)this.name).trim();
            return this.comparator.compare(value1, value2);
        }
        catch (Exception e) {
            log.error((Object)e);
            return 0;
        }
    }

    public Comparator<String> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<String> comparator) {
        this.comparator = comparator;
    }
}

