/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ZipFileUtils {
    private static Log log = LogFactory.getLog(ZipFileUtils.class);
    private static final int BUFFER = 1024;

    public static void unzip(ZipFile file, String dirname) {
        File dir = new File(dirname);
        dir.mkdirs();
        ArrayList<ZipEntry> dirs = new ArrayList<ZipEntry>();
        ArrayList<ZipEntry> files = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> e = file.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) {
                dirs.add(entry);
                continue;
            }
            files.add(entry);
        }
        for (ZipEntry entry : dirs) {
            File eDir = new File(String.valueOf(dirname) + "/" + entry.getName());
            eDir.mkdirs();
        }
        for (ZipEntry entry : files) {
            log.debug((Object)("Extracting: " + entry));
            ZipFileUtils.unzipEntry(file, entry, dirname);
        }
    }

    private static void unzipEntry(ZipFile file, ZipEntry entry, String dir) {
        if (entry == null) {
            return;
        }
        try {
            int count;
            BufferedInputStream is = new BufferedInputStream(file.getInputStream(entry));
            byte[] data = new byte[1024];
            FileOutputStream fos = new FileOutputStream(String.valueOf(dir) + "/" + entry.getName());
            BufferedOutputStream dest = new BufferedOutputStream(fos, 1024);
            while ((count = ((InputStream)is).read(data, 0, 1024)) != -1) {
                ((OutputStream)dest).write(data, 0, count);
            }
            ((OutputStream)dest).flush();
            ((OutputStream)dest).close();
            ((InputStream)is).close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public static void zip(File file, String zipFilename) throws Exception {
        if (file.isDirectory()) {
            ZipFileUtils.zip(file.listFiles(), zipFilename);
        } else {
            ZipFileUtils.zip(new File[]{file}, zipFilename);
        }
    }

    public static void zip(File[] files, String zipFilename) throws Exception {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(zipFilename));
        ZipOutputStream zos = new ZipOutputStream(os);
        byte[] data = new byte[1024];
        int i = 0;
        while (i < files.length) {
            int count;
            log.debug((Object)("Adding: " + files[i]));
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(files[i]), 1024);
            ZipEntry entry = new ZipEntry(files[i].getName());
            zos.putNextEntry(entry);
            while ((count = ((InputStream)is).read(data, 0, 1024)) != -1) {
                zos.write(data, 0, count);
            }
            ((InputStream)is).close();
            ++i;
        }
        zos.close();
        log.debug((Object)("Zipped file: " + zipFilename));
    }

    public static void addFile(File zipFile, File addFile) throws Exception {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(zipFile));
        ZipOutputStream zos = new ZipOutputStream(os);
        log.debug((Object)("Adding: " + addFile.getName()));
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(addFile), 1024);
        ZipEntry entry = new ZipEntry(addFile.getName());
        zos.putNextEntry(entry);
        ZipFileUtils.copy(is, zos);
        log.debug((Object)("Added " + addFile.getName() + " to " + zipFile.getName()));
    }

    private static void copy(InputStream is, OutputStream os) throws IOException {
        int count;
        byte[] data = new byte[1024];
        while ((count = is.read(data, 0, 1024)) != -1) {
            os.write(data, 0, count);
        }
        is.close();
        os.close();
    }

    public static byte[] readEntryAsByteArray(ZipFile file, ZipEntry ze) throws IOException {
        InputStream is = file.getInputStream(ze);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ZipFileUtils.copy(is, os);
        return os.toByteArray();
    }
}

