/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.ui.bind;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.ui.View;
import org.jdal.ui.bind.AbstractBinder;
import org.jdal.ui.bind.BinderHolder;
import org.jdal.ui.bind.PropertyBinder;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

public class ViewBinder
extends AbstractBinder
implements BinderHolder {
    private static final Log log = LogFactory.getLog(ViewBinder.class);

    @Override
    public void doRefresh() {
        Object value = this.getValue();
        View<Object> view = this.getView();
        view.setModel(value);
        view.refresh();
    }

    private View<Object> getView() {
        View view = (View)this.component;
        return view;
    }

    @Override
    public void doUpdate() {
        View<Object> view = this.getView();
        BindingResult br = view.getBindingResult();
        if (br != null) {
            br.setNestedPath(this.propertyName);
        }
        view.update();
        this.setValue(view.getModel());
        if (br != null && view.getBindingResult().hasErrors()) {
            for (ObjectError oe : view.getBindingResult().getAllErrors()) {
                this.getBindingResult().addError(oe);
            }
        }
    }

    @Override
    public PropertyBinder getBinder(String propertyName) {
        View<Object> view = this.getView();
        if (view instanceof BinderHolder) {
            return ((BinderHolder)((Object)view)).getBinder(propertyName);
        }
        log.warn((Object)("View class: [" + view.getClass().getName() + "] " + "must implements BinderHolder to validate property: [" + propertyName + "]"));
        return null;
    }
}

