/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.ui.bind;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.jdal.dao.Dao;
import org.jdal.ui.bind.ControlInitializer;
import org.jdal.util.BeanUtils;
import org.jdal.util.comparator.PropertyComparator;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class ControlInitializerSupport
implements ControlInitializer {
    protected Dao<Object, ? extends Serializable> dao;
    private boolean initializeEntities = false;
    private boolean firstNull = false;

    protected List<Object> getEntityList(Class<?> propertyType, String sortProperty) {
        List<Object> entities = this.dao.getAll(propertyType);
        this.sort(entities, sortProperty);
        if (this.isInitializeEntities()) {
            for (Object obj : entities) {
                this.dao.initialize(obj);
            }
        }
        if (this.isFirstNull()) {
            entities.add(0, null);
        }
        return entities;
    }

    protected void sort(List entities, String sortProperty) {
        if (!StringUtils.isEmpty((Object)sortProperty)) {
            Collections.sort(entities, new PropertyComparator(sortProperty));
        }
    }

    protected List<Object> getEntityList(Class<?> propertyType) {
        return this.getEntityList(propertyType, null);
    }

    protected List<Object> getValueList(List entities, String propertyName) {
        ArrayList<Object> values = new ArrayList<Object>(entities.size());
        for (Object value : entities) {
            if (value == null) {
                values.add(null);
                continue;
            }
            values.add(BeanUtils.getProperty(value, propertyName));
        }
        return values;
    }

    protected Annotation[] getAnnotations(String property, Class<?> clazz) {
        Method method;
        Field field = ReflectionUtils.findField(clazz, (String)property);
        Object[] fa = new Annotation[]{};
        if (field != null) {
            fa = field.getAnnotations();
        }
        if ((method = BeanUtils.getPropertyDescriptor(clazz, (String)property).getReadMethod()) != null) {
            Object[] ma = method.getAnnotations();
            Annotation[] annotations = (Annotation[])ArrayUtils.addAll((Object[])fa, (Object[])ma);
            return annotations;
        }
        return fa;
    }

    public Dao<Object, ? extends Serializable> getPersistentService() {
        return this.dao;
    }

    public void setPersistentService(Dao<Object, ? extends Serializable> Dao2) {
        this.dao = Dao2;
    }

    public boolean isInitializeEntities() {
        return this.initializeEntities;
    }

    @Override
    public void setInitializeEntities(boolean initializeEntities) {
        this.initializeEntities = initializeEntities;
    }

    public boolean isFirstNull() {
        return this.firstNull;
    }

    public void setFirstNull(boolean firstNull) {
        this.firstNull = firstNull;
    }
}

