/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.ui.bind;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.beans.PropertyUtils;
import org.jdal.ui.Binder;
import org.jdal.ui.ModelHolder;
import org.jdal.ui.bind.BinderFactory;
import org.jdal.ui.bind.BinderHolder;
import org.jdal.ui.bind.DirectFieldAccessor;
import org.jdal.ui.bind.PropertyBinder;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

public class CompositeBinder<T>
implements Binder<T>,
BinderHolder,
ModelHolder<T>,
Serializable {
    private static final Log log = LogFactory.getLog(CompositeBinder.class);
    private BinderFactory binderFactory;
    private Map<String, Binder<T>> binders = new HashMap<String, Binder<T>>();
    private T model;
    private BindingResult bindingResult;
    private List<String> ignoredProperties = new ArrayList<String>();

    public CompositeBinder() {
    }

    public CompositeBinder(T model) {
        this.model = model;
    }

    public void bind(Object component, String propertyName) {
        this.bind(component, propertyName, false);
    }

    public void bind(Object component, String propertyName, boolean readOnly) {
        this.bind(component, propertyName, this, readOnly);
    }

    public void bind(Object component, String propertyName, Object model, boolean readOnly) {
        PropertyBinder binder = this.binderFactory.getBinder(component.getClass());
        if (binder != null) {
            binder.bind(component, propertyName, model, readOnly);
            this.addBinder(propertyName, binder);
        }
    }

    public void addBinder(String propertyName, PropertyBinder binder) {
        this.binders.put(propertyName, binder);
    }

    @Override
    public void refresh() {
        for (Binder<T> b : this.binders.values()) {
            b.refresh();
        }
    }

    public void addBinder(Binder<?> binder, String name) {
        this.binders.put(name, binder);
    }

    @Override
    public void update() {
        this.bindingResult = null;
        for (Binder<T> b : this.binders.values()) {
            b.update();
        }
    }

    @Override
    public PropertyBinder getBinder(String propertyName) {
        PropertyBinder binder = (PropertyBinder)this.binders.get(propertyName);
        if (binder != null) {
            return binder;
        }
        if (PropertyUtils.isNested(propertyName)) {
            BinderHolder binderHolder = (BinderHolder)((Object)this.binders.get(PropertyUtils.getFirstPropertyName(propertyName)));
            return binderHolder != null ? binderHolder.getBinder(PropertyUtils.getNestedPath(propertyName)) : null;
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        return this.binders.keySet();
    }

    public Collection<Binder<T>> getPropertyBinders() {
        return this.binders.values();
    }

    public BinderFactory getBinderFactory() {
        return this.binderFactory;
    }

    public void setBinderFactory(BinderFactory binderFactory) {
        this.binderFactory = binderFactory;
    }

    @Override
    public T getModel() {
        return this.model;
    }

    @Override
    public void setModel(T model) {
        this.model = model;
    }

    @Override
    public BindingResult getBindingResult() {
        if (this.getModel() == null) {
            return null;
        }
        if (this.bindingResult == null) {
            this.createBindingResult();
            for (Binder<T> b : this.binders.values()) {
                if (b.getBindingResult() == null || !this.bindingResult.getObjectName().equals(b.getBindingResult().getObjectName())) continue;
                this.bindingResult.addAllErrors((Errors)b.getBindingResult());
            }
        }
        return this.bindingResult;
    }

    private void createBindingResult() {
        this.bindingResult = new BeanPropertyBindingResult(this.getModel(), this.getModel().getClass().getSimpleName());
    }

    public void autobind(Object view) {
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(this.getModel());
        DirectFieldAccessor viewPropertyAccessor = new DirectFieldAccessor(view);
        PropertyDescriptor[] propertyDescriptorArray = bw.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object control;
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            String propertyName = pd.getName();
            if (!this.ignoredProperties.contains(propertyName) && viewPropertyAccessor.isReadableProperty(propertyName) && (control = viewPropertyAccessor.getPropertyValue(propertyName)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found control: " + control.getClass().getSimpleName() + " for property: " + propertyName));
                }
                this.bind(control, propertyName);
            }
            ++n2;
        }
    }

    public List<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public void setIgnoredProperties(List<String> ignoredProperties) {
        this.ignoredProperties = ignoredProperties;
    }

    public void ignoreProperty(String propertyName) {
        this.ignoredProperties.add(propertyName);
    }
}

