/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.ui.bind;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.beans.PropertyUtils;
import org.jdal.beans.SimpleTypeConverter;
import org.jdal.text.PeriodFormatAnnotationFactory;
import org.jdal.ui.DefaultModelHolder;
import org.jdal.ui.ModelHolder;
import org.jdal.ui.bind.ControlBindingErrorProcessor;
import org.jdal.ui.bind.PropertyBinder;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;

public abstract class AbstractBinder
implements PropertyBinder,
Serializable {
    private static final Log log = LogFactory.getLog(AbstractBinder.class);
    protected String propertyName;
    protected Object oldValue;
    private ModelHolder<Object> modelHolder;
    protected Object component;
    protected boolean readOnly = false;
    private ControlBindingErrorProcessor errorProcessor = new ControlBindingErrorProcessor();
    private BindingResult bindingResult;
    private static DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
    private SimpleTypeConverter converter = new SimpleTypeConverter();

    public AbstractBinder() {
        conversionService.addFormatterForFieldAnnotation((AnnotationFormatterFactory)new PeriodFormatAnnotationFactory());
        this.converter.setConversionService((ConversionService)conversionService);
        this.converter.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor(SimpleDateFormat.getDateTimeInstance(), true));
    }

    @Override
    public final void bind(Object component, String propertyName, Object model) {
        this.bind(component, propertyName, model, false);
    }

    @Override
    public final void bind(Object component, String propertyName, Object model, boolean readOnly) {
        this.propertyName = propertyName;
        this.setModel(model);
        this.component = component;
        this.readOnly = readOnly;
        this.doBind();
    }

    protected void doBind() {
    }

    @Override
    public final void refresh() {
        this.doRefresh();
    }

    @Override
    public final void update() {
        if (!this.readOnly && this.modelHolder != null) {
            this.bindingResult = this.createBindingResult();
            this.doUpdate();
        }
    }

    protected BindingResult createBindingResult() {
        Object model = this.getModel();
        return new BeanPropertyBindingResult(model, model.getClass().getSimpleName());
    }

    protected abstract void doRefresh();

    protected abstract void doUpdate();

    protected void setValue(Object value) {
        BeanWrapper wrapper = this.getBeanWrapper();
        try {
            wrapper.setPropertyValue(this.propertyName, value);
            this.oldValue = value;
        }
        catch (PropertyAccessException pae) {
            log.error((Object)pae);
            this.errorProcessor.processPropertyAccessException(this.component, pae, this.bindingResult);
        }
    }

    protected Object getValue() {
        BeanWrapper wrapper = this.getBeanWrapper();
        Object value = null;
        try {
            value = wrapper.getPropertyValue(this.propertyName);
        }
        catch (BeansException e) {
            log.error((Object)e);
        }
        return value;
    }

    private BeanWrapper getBeanWrapper() {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.getModel());
        wrapper.setConversionService((ConversionService)conversionService);
        wrapper.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor(SimpleDateFormat.getDateTimeInstance(), true));
        return wrapper;
    }

    protected <T> T convertIfNecessary(Object value, Class<T> requiredType) {
        try {
            return (T)conversionService.convert(value, new TypeDescriptor(this.getProperty()), TypeDescriptor.valueOf(requiredType));
        }
        catch (ConversionException ce) {
            return this.converter.convertIfNecessary(value, requiredType);
        }
    }

    protected Property getProperty() {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        return new Property(this.getModel().getClass(), pd.getReadMethod(), pd.getWriteMethod());
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    protected Object getOldValue() {
        return this.oldValue;
    }

    protected void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    @Override
    public Object getModel() {
        return this.modelHolder != null ? this.modelHolder.getModel() : null;
    }

    @Override
    public void setModel(Object model) {
        if (model instanceof ModelHolder) {
            this.modelHolder = model;
        } else {
            model = new DefaultModelHolder<Object>(model);
        }
    }

    @Override
    public Object getComponent() {
        return this.component;
    }

    public void setComponent(Object component) {
        this.component = component;
    }

    @Override
    public BindingResult getBindingResult() {
        return this.bindingResult;
    }

    public Class<?> getPropertyType() {
        return this.getPropertyDescriptor().getPropertyType();
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return PropertyUtils.getPropertyDescriptor(this.getModel().getClass(), this.propertyName);
    }
}

