/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.text;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.text.PeriodFormat;
import org.jdal.text.PeriodFormatter;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.format.annotation.NumberFormat;
import org.springframework.format.number.NumberFormatAnnotationFormatterFactory;

public abstract class FormatUtils {
    private static final Log log = LogFactory.getLog(FormatUtils.class);
    private static AnnotationFormatterFactory<NumberFormat> numberFormatFactory = new NumberFormatAnnotationFormatterFactory();

    public static Printer<?> getPrinter(Class<?> clazz, String propertyName) {
        return FormatUtils.getFormatter(clazz, propertyName);
    }

    public static Parser<?> getParser(Class<?> clazz, String propertyName) {
        return FormatUtils.getFormatter(clazz, propertyName);
    }

    public static Formatter<?> getFormatter(Class<?> clazz, String propertyName) {
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(clazz, (String)propertyName);
        if (pd != null) {
            NumberFormat format = FormatUtils.getAnnotation(pd, NumberFormat.class);
            if (format != null) {
                return (Formatter)numberFormatFactory.getPrinter((Annotation)format, pd.getPropertyType());
            }
            PeriodFormat periodFormat = FormatUtils.getAnnotation(pd, PeriodFormat.class);
            if (periodFormat != null) {
                return new PeriodFormatter();
            }
        }
        return null;
    }

    public static <A extends Annotation> A getAnnotation(PropertyDescriptor pd, Class<A> annotationType) {
        Annotation annotation = AnnotationUtils.getAnnotation((Method)pd.getReadMethod(), annotationType);
        if (annotation != null) {
            return (A)annotation;
        }
        Field field = FormatUtils.getDeclaredField(pd);
        if (field != null) {
            annotation = AnnotationUtils.getAnnotation((AnnotatedElement)field, annotationType);
        }
        return (A)annotation;
    }

    public static Field getDeclaredField(PropertyDescriptor pd) {
        try {
            return pd.getReadMethod().getDeclaringClass().getDeclaredField(pd.getName());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot access to field: " + pd.getName()));
            }
            return null;
        }
    }
}

