/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.service;

import java.io.Serializable;
import org.aopalliance.aop.Advice;
import org.jdal.dao.Dao;
import org.jdal.dao.DaoFactory;
import org.jdal.logic.PersistentManager;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.MatchAlwaysTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class PersistentServiceFactory {
    @Autowired
    private DaoFactory daoFactory;
    @Autowired
    private PlatformTransactionManager transactionManager;

    public <T> PersistentManager<T, Serializable> createPersistentService(Class<T> clazz) {
        Dao<T, Serializable> dao = this.daoFactory.createDao(clazz);
        PersistentManager<T, Serializable> manager = new PersistentManager<T, Serializable>();
        manager.setDao(dao);
        return this.makeTransactionalProxy(manager);
    }

    public <T> PersistentManager<T, Serializable> makeTransactionalProxy(PersistentManager<T, Serializable> service) {
        ProxyFactory factory = new ProxyFactory(service);
        factory.setInterfaces(new Class[]{Dao.class});
        TransactionInterceptor interceptor = new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)new MatchAlwaysTransactionAttributeSource());
        factory.addAdvice((Advice)interceptor);
        factory.setTarget(service);
        return (PersistentManager)factory.getProxy();
    }
}

