/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.mock;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.easymock.EasyMock;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class EasyMockReplacer
implements BeanFactoryPostProcessor {
    private List<Class<?>> replacedClasses = new ArrayList();
    private Log log = LogFactory.getLog(EasyMockReplacer.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        for (Class<?> clazz : this.replacedClasses) {
            this.replaceBean(clazz, factory);
        }
    }

    private void replaceBean(Class<?> clazz, ConfigurableListableBeanFactory factory) {
        String[] names;
        Object mock = EasyMock.createMock(clazz);
        String[] stringArray = names = factory.getBeanNamesForType(clazz);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.log.info((Object)("Registering bean " + name + " with mock " + clazz.getName()));
            factory.registerSingleton(name, mock);
            ++n2;
        }
    }

    public boolean add(Class<?> clazz) {
        return this.replacedClasses.add(clazz);
    }

    public boolean remove(Class<?> clazz) {
        return this.replacedClasses.remove(clazz);
    }
}

