/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.logic;

import org.apache.commons.lang.StringUtils;
import org.jdal.dao.UserPreferenceDao;
import org.jdal.model.TableState;
import org.jdal.model.User;
import org.jdal.model.UserPreference;
import org.jdal.service.TableService;

public abstract class TableManagerSupport
implements TableService {
    private static final String VISIBLE_COLUMNS = "visible_columns";
    private static final String PAGE_SIZE = "page_size";
    private UserPreferenceDao userPreferenceDao;
    private String separator = ".";

    @Override
    public TableState getState(String name) {
        if (this.getUser() == null) {
            return null;
        }
        TableState state = null;
        String visibleColumns = this.userPreferenceDao.findUserPreferenceValue(this.getUser(), this.getPreferenceName(name, VISIBLE_COLUMNS));
        String pageSize = this.userPreferenceDao.findUserPreferenceValue(this.getUser(), this.getPreferenceName(name, PAGE_SIZE));
        if (visibleColumns != null || pageSize != null) {
            state = new TableState();
            state.setName(name);
            state.setVisibleColumns(visibleColumns);
            if (StringUtils.isNumeric((String)pageSize)) {
                state.setPageSize(Integer.parseInt(pageSize));
            }
        }
        return state;
    }

    protected abstract User getUser();

    private String getPreferenceName(String name, String preferenceName) {
        return String.valueOf(name) + this.separator + preferenceName;
    }

    @Override
    public void saveState(TableState state) {
        this.savePreference(this.getPreferenceName(state.getName(), VISIBLE_COLUMNS), org.springframework.util.StringUtils.collectionToCommaDelimitedString(state.getVisibleColumns()));
        this.savePreference(this.getPreferenceName(state.getName(), PAGE_SIZE), String.valueOf(state.getPageSize()));
    }

    private void savePreference(String name, String value) {
        UserPreference p = this.userPreferenceDao.findUserPreference(this.getUser(), name);
        if (p == null) {
            p = this.userPreferenceDao.createUserPreference();
            p.setUser(this.getUser());
            p.setName(name);
        }
        p.setValue(value);
        this.userPreferenceDao.save(p);
    }

    public UserPreferenceDao getUserPreferenceDao() {
        return this.userPreferenceDao;
    }

    public void setUserPreferenceDao(UserPreferenceDao userPreferenceDao) {
        this.userPreferenceDao = userPreferenceDao;
    }
}

