/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.logic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdal.dao.Dao;
import org.jdal.dao.Page;
import org.jdal.service.PersistentService;

public class PersistentManager<T, PK extends Serializable>
implements PersistentService<T, PK> {
    public static final int DEFAULT_DEPTH = 2;
    protected Dao<T, PK> dao;

    @Override
    public void delete(T entity) {
        this.dao.delete(entity);
    }

    @Override
    public T initialize(T entity, int depth) {
        this.dao.initialize(entity, depth);
        return entity;
    }

    @Override
    public T initialize(T entity) {
        this.dao.initialize(entity);
        return entity;
    }

    @Override
    public List<T> getAll() {
        return this.dao.getAll();
    }

    @Override
    public T save(T entity) {
        return this.dao.save(entity);
    }

    @Override
    public void delete(Collection<T> collection) {
        for (T t : collection) {
            this.dao.delete(t);
        }
    }

    @Override
    public Collection<T> save(Collection<T> collection) {
        ArrayList<T> saved = new ArrayList<T>();
        for (T t : collection) {
            saved.add(this.dao.save(t));
        }
        return saved;
    }

    @Override
    public void deleteById(PK id) {
        this.dao.deleteById(id);
    }

    @Override
    public void deleteById(Collection<PK> ids) {
        for (Serializable id : ids) {
            this.dao.deleteById(id);
        }
    }

    @Override
    public List<Serializable> getKeys(Page<T> page) {
        return this.dao.getKeys(page);
    }

    @Override
    public <K> Page<K> getPage(Page<K> page) {
        return this.dao.getPage(page);
    }

    public Dao<T, PK> getDao() {
        return this.dao;
    }

    public void setDao(Dao<T, PK> dao) {
        this.dao = dao;
    }

    @Override
    public T get(PK id) {
        return this.dao.get(id);
    }

    @Override
    public <E> E get(PK id, Class<E> clazz) {
        return this.dao.get(id, clazz);
    }

    @Override
    public <E> List<E> getAll(Class<E> clazz) {
        return this.dao.getAll(clazz);
    }

    @Override
    public Class<T> getEntityClass() {
        if (this.dao != null) {
            return this.dao.getEntityClass();
        }
        return null;
    }

    @Override
    public boolean exists(PK id) {
        return this.dao.exists(id);
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        return this.dao.findByNamedQuery(queryName, queryParams);
    }
}

