/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.logic;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdal.dao.Dao;
import org.jdal.dao.Page;
import org.springframework.beans.factory.annotation.Autowired;

public class ContextPersistentManager
implements Dao<Object, Serializable> {
    @Autowired
    private List<Dao> services;
    private Map<Class<?>, Dao<Object, Serializable>> serviceMap = new ConcurrentHashMap();

    public void init() {
        for (Dao ps : this.services) {
            if (ps.getEntityClass() == null) continue;
            this.serviceMap.put(ps.getEntityClass(), ps);
        }
    }

    @Override
    public <K> Page<K> getPage(Page<K> page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Serializable> getKeys(Page<Object> page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object initialize(Object entity, int depth) {
        return this.getDao(entity.getClass()).initialize(entity);
    }

    @Override
    public Object initialize(Object entity) {
        return this.getDao(entity.getClass()).initialize(entity);
    }

    @Override
    public Object save(Object entity) {
        return this.getDao(entity.getClass()).save(entity);
    }

    @Override
    public void delete(Object entity) {
        this.getDao(entity.getClass()).delete(entity);
    }

    @Override
    public void deleteById(Serializable id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Object> getAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> save(Collection<Object> collection) {
        if (collection.isEmpty()) {
            return collection;
        }
        return this.getDao(collection.iterator().next().getClass()).save(collection);
    }

    @Override
    public void delete(Collection<Object> collection) {
        if (!collection.isEmpty()) {
            this.getDao(collection.iterator().next().getClass()).delete(collection);
        }
    }

    @Override
    public void deleteById(Collection<Serializable> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Serializable id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E get(Serializable id, Class<E> clazz) {
        return this.getDao(clazz).get(id, clazz);
    }

    @Override
    public <E> List<E> getAll(Class<E> clazz) {
        return this.getDao(clazz).getAll(clazz);
    }

    @Override
    public Class<Object> getEntityClass() {
        return Object.class;
    }

    private Dao<Object, Serializable> getDao(Class<?> clazz) {
        return this.serviceMap.get(clazz);
    }

    @Override
    public boolean exists(Serializable id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Object> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        throw new UnsupportedOperationException();
    }
}

