/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.hibernate;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.criterion.Example;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.impl.SessionImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.collection.CollectionPersister;

public abstract class HibernateUtils {
    public static final int DEFAULT_DEPTH = 2;
    private static final Log log = LogFactory.getLog(HibernateUtils.class);

    public static void initialize(SessionFactory sessionFactory, Object obj, int depth) {
        HibernateUtils.initialize(sessionFactory, obj, new ArrayList<Object>(), depth);
    }

    public static void initialize(SessionFactory sessionFactory, Object obj) {
        HibernateUtils.initialize(sessionFactory, obj, new ArrayList<Object>(), 2);
    }

    private static void initialize(SessionFactory sessionFactory, Object obj, List<Object> initializedObjects, int depth) {
        Object[] pvs;
        if (obj == null || depth == 0) {
            return;
        }
        if (!Hibernate.isInitialized((Object)obj)) {
            if (obj instanceof Collection) {
                HibernateUtils.initializeCollection(sessionFactory, obj, initializedObjects, depth);
                return;
            }
            sessionFactory.getCurrentSession().buildLockRequest(LockOptions.NONE).lock(obj);
            Hibernate.initialize((Object)obj);
        }
        if (initializedObjects.contains(obj)) {
            return;
        }
        initializedObjects.add(obj);
        ClassMetadata classMetadata = HibernateUtils.getClassMetadata(sessionFactory, obj);
        if (classMetadata == null) {
            return;
        }
        Object[] objectArray = pvs = classMetadata.getPropertyValues(obj, EntityMode.POJO);
        int n = pvs.length;
        int n2 = 0;
        while (n2 < n) {
            Object pv = objectArray[n2];
            HibernateUtils.initialize(sessionFactory, pv, initializedObjects, depth - 1);
            ++n2;
        }
    }

    private static void initializeCollection(SessionFactory sessionFactory, Object obj, List<Object> initializedObjects, int depth) {
        Collection collection = (Collection)obj;
        HibernateUtils.initializeCollection(collection, (Session)sessionFactory.getCurrentSession());
        for (Object o : collection) {
            HibernateUtils.initialize(sessionFactory, o, initializedObjects, depth - 1);
        }
    }

    public static void initializeCollection(Collection collection, Session session) {
        if (collection instanceof AbstractPersistentCollection) {
            AbstractPersistentCollection ps = (AbstractPersistentCollection)collection;
            log.debug((Object)("Initalizing PersistentCollection of role: " + ps.getRole()));
            if (!ps.wasInitialized()) {
                SessionImpl source = (SessionImpl)session;
                PersistenceContext context = source.getPersistenceContext();
                CollectionPersister cp = source.getFactory().getCollectionPersister(ps.getRole());
                if (context.getCollectionEntry((PersistentCollection)ps) == null) {
                    context.addUninitializedDetachedCollection(cp, (PersistentCollection)ps);
                }
                ps.setCurrentSession(context.getSession());
                Hibernate.initialize((Object)collection);
            }
        }
    }

    private static ClassMetadata getClassMetadata(SessionFactory sessionFactory, Object obj) {
        return sessionFactory.getClassMetadata(Hibernate.getClass((Object)obj));
    }

    public static String getIdentifierPropertyName(SessionFactory sessionFactory, Object obj) {
        ClassMetadata cm = HibernateUtils.getClassMetadata(sessionFactory, obj);
        return cm == null ? null : cm.getIdentifierPropertyName();
    }

    public static Set<String> getFieldNamesByType(Object obj, Class<?> type) {
        Field[] fields;
        HashSet<String> fieldNames = new HashSet<String>(0);
        Field[] fieldArray = fields = obj.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (type.equals(field.getType())) {
                fieldNames.add(field.getName());
            }
            ++n2;
        }
        return fieldNames;
    }

    public static Example excludeBooleanFields(Object instance) {
        Example result = Example.create((Object)instance).excludeZeroes();
        Set<String> fieldNames = HibernateUtils.getFieldNamesByType(instance, Boolean.class);
        fieldNames.addAll(HibernateUtils.getFieldNamesByType(instance, Boolean.TYPE));
        for (String fieldName : fieldNames) {
            result.excludeProperty(fieldName);
        }
        return result;
    }

    public static String findAliasForPropertyPath(Criteria criteria, String propertyPath) {
        CriteriaImpl c = (CriteriaImpl)criteria;
        Iterator iter = c.iterateSubcriteria();
        if (iter.hasNext()) {
            CriteriaImpl.Subcriteria subCriteria = (CriteriaImpl.Subcriteria)iter.next();
            if (propertyPath.equals(subCriteria.getPath())) {
                // empty if block
            }
            return subCriteria.getAlias();
        }
        return null;
    }
}

