/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.gis.google;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.gis.google.RouteRequest;

public class DirectionsService {
    private static final Log log = LogFactory.getLog(DirectionsService.class);
    private String serverUrl = "http://maps.google.com/maps/api/directions/json";
    private GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 4326);

    public MultiLineString getRoute(RouteRequest request) {
        try {
            URL url = new URL(String.valueOf(this.serverUrl) + "?" + request.toString());
            log.debug((Object)("Sending request: " + url.toString()));
            return this.parseResponse(url.getContent());
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    private MultiLineString parseResponse(Object response) throws IOException {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        String jsonString = this.responseToString(response);
        JSONObject json = JSONObject.fromObject((Object)jsonString);
        if ("OK".equals(json.get("status"))) {
            JSONArray routes = json.getJSONArray("routes");
            JSONArray legs = routes.getJSONObject(0).getJSONArray("legs");
            JSONArray steps = legs.getJSONObject(0).getJSONArray("steps");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get route with " + steps.size() + " steps"));
            }
            for (JSONObject step : steps) {
                String polyline = step.getJSONObject("polyline").getString("points");
                LineString line = this.decodePolyline(polyline);
                lines.add(line);
            }
        }
        return new MultiLineString(lines.toArray(new LineString[0]), this.factory);
    }

    private String responseToString(Object response) throws IOException {
        int i;
        StringWriter writer = new StringWriter();
        InputStreamReader reader = new InputStreamReader((InputStream)response);
        while ((i = reader.read()) != -1) {
            ((Writer)writer).write(i);
        }
        return ((Object)writer).toString();
    }

    private LineString decodePolyline(String encoded) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        int index = 0;
        int len = encoded.length();
        int lat = 0;
        int lng = 0;
        while (index < len) {
            int b;
            int shift = 0;
            int result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int dlat = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            lat += dlat;
            shift = 0;
            result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int dlng = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            coordinates.add(new Coordinate((double)lat / 100000.0, (double)(lng += dlng) / 100000.0));
        }
        return new LineString((CoordinateSequence)new CoordinateArraySequence(coordinates.toArray(new Coordinate[0])), this.factory);
    }

    public static void main(String[] args) {
        RouteRequest request = new RouteRequest();
        request.setDestination(37.2582, -6.9542);
        request.setOrigin(37.2546, -6.9504);
        DirectionsService service = new DirectionsService();
        service.getRoute(request);
    }
}

