/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.dao.jpa;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang.StringUtils;
import org.jdal.beans.PropertyUtils;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;

public abstract class JpaUtils {
    private static String ALIAS_PATTERN_STRING = "(?<=from)\\s+(?:\\S+)\\s+(?:as\\s+)*(\\w*)";
    private static Pattern ALIAS_PATTERN = Pattern.compile(ALIAS_PATTERN_STRING, 2);
    private static String FROM_PATTERN_STRING = "(from.*+)";
    private static Pattern FROM_PATTERN = Pattern.compile(FROM_PATTERN_STRING, 2);
    private static volatile int aliasCount = 0;

    public static <T> Long count(EntityManager em, CriteriaQuery<T> criteria) {
        return (Long)em.createQuery(JpaUtils.countCriteria(em, criteria)).getSingleResult();
    }

    public static <T> CriteriaQuery<Long> countCriteria(EntityManager em, CriteriaQuery<T> criteria) {
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery countCriteria = builder.createQuery(Long.class);
        JpaUtils.copyCriteriaWithoutSelectionAndOrder(criteria, countCriteria);
        Expression countExpression = criteria.isDistinct() ? builder.countDistinct(JpaUtils.findRoot(countCriteria, criteria.getResultType())) : builder.count(JpaUtils.findRoot(countCriteria, criteria.getResultType()));
        return countCriteria.select((Selection)countExpression);
    }

    public static synchronized <T> String getOrCreateAlias(Selection<T> selection) {
        String alias;
        if (aliasCount > 1000) {
            aliasCount = 0;
        }
        if ((alias = selection.getAlias()) == null) {
            alias = "JDAL_generatedAlias" + aliasCount++;
            selection.alias(alias);
        }
        return alias;
    }

    public static <T> Root<T> findRoot(CriteriaQuery<T> query) {
        return JpaUtils.findRoot(query, query.getResultType());
    }

    public static <T> Root<T> findRoot(CriteriaQuery<?> query, Class<T> clazz) {
        for (Root r : query.getRoots()) {
            if (!clazz.equals(r.getJavaType())) continue;
            return (Root)r.as(clazz);
        }
        return (Root)query.getRoots().iterator().next();
    }

    public static <T, K> Join<T, K> findJoinedType(CriteriaQuery<T> query, Class<T> rootClass, Class<K> joinClass) {
        Root<T> root = JpaUtils.findRoot(query, rootClass);
        Join join = null;
        for (Join j : root.getJoins()) {
            if (!j.getJoinType().equals(joinClass)) continue;
            join = j;
        }
        return join;
    }

    public static <T> Path<T> getPath(Path<?> path, String propertyPath) {
        if (StringUtils.isEmpty((String)propertyPath)) {
            return path;
        }
        String name = StringUtils.substringBefore((String)propertyPath, (String)PropertyUtils.PROPERTY_SEPARATOR);
        Path p = path.get(name);
        return JpaUtils.getPath(p, StringUtils.substringAfter((String)propertyPath, (String)PropertyUtils.PROPERTY_SEPARATOR));
    }

    public static String createCountQueryString(String queryString) {
        return queryString.replaceFirst("^.*(?i)from", "select count (*) from ");
    }

    public static String getAlias(String queryString) {
        Matcher m = ALIAS_PATTERN.matcher(queryString);
        return m.find() ? m.group(1) : null;
    }

    public static String addOrder(String queryString, String propertyPath, boolean asc) {
        if (StringUtils.containsIgnoreCase((String)queryString, (String)"order by")) {
            return queryString;
        }
        StringBuilder sb = new StringBuilder(queryString);
        sb.append(" ORDER BY ");
        sb.append(JpaUtils.getAlias(queryString));
        sb.append(".");
        sb.append(propertyPath);
        sb.append(" ");
        sb.append(asc ? "ASC" : "DESC");
        return sb.toString();
    }

    public static String getKeyQuery(String queryString, String name) {
        Matcher m = FROM_PATTERN.matcher(queryString);
        if (m.find()) {
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append(JpaUtils.getAlias(queryString));
            sb.append(".");
            sb.append(name);
            sb.append(" ");
            sb.append(m.group());
            return sb.toString();
        }
        return null;
    }

    public static void copyCriteriaNoSelection(CriteriaQuery<?> from, CriteriaQuery<?> to) {
        JpaUtils.copyCriteriaWithoutSelectionAndOrder(from, to);
        to.orderBy(from.getOrderList());
    }

    private static void copyCriteriaWithoutSelectionAndOrder(CriteriaQuery<?> from, CriteriaQuery<?> to) {
        Predicate predicate;
        if (!JpaUtils.isEclipseLink(from) || from.getRestriction() == null) {
            for (Root root : from.getRoots()) {
                Root dest = to.from(root.getJavaType());
                dest.alias(JpaUtils.getOrCreateAlias(root));
                JpaUtils.copyJoins(root, dest);
            }
        }
        to.groupBy(from.getGroupList());
        to.distinct(from.isDistinct());
        if (from.getGroupRestriction() != null) {
            to.having((Expression)from.getGroupRestriction());
        }
        if ((predicate = from.getRestriction()) != null) {
            to.where((Expression)predicate);
        }
    }

    private static boolean isEclipseLink(CriteriaQuery<?> from) {
        return from.getClass().getName().contains("org.eclipse.persistence");
    }

    public static <T> void copyCriteria(CriteriaQuery<T> from, CriteriaQuery<T> to) {
        JpaUtils.copyCriteriaNoSelection(from, to);
        to.select(from.getSelection());
    }

    public static void copyJoins(From<?, ?> from, From<?, ?> to) {
        for (Join j : from.getJoins()) {
            Join toJoin = to.join(j.getAttribute().getName(), j.getJoinType());
            toJoin.alias(JpaUtils.getOrCreateAlias(j));
            JpaUtils.copyJoins(j, toJoin);
        }
        for (Fetch f : from.getFetches()) {
            Fetch toFetch = to.fetch(f.getAttribute().getName());
            JpaUtils.copyFetches(f, toFetch);
        }
    }

    public static void copyFetches(Fetch<?, ?> from, Fetch<?, ?> to) {
        for (Fetch f : from.getFetches()) {
            Fetch toFetch = to.fetch(f.getAttribute().getName());
            JpaUtils.copyFetches(f, toFetch);
        }
    }

    public static boolean hasPath(Path<?> path, String propertyPath) {
        try {
            JpaUtils.getPath(path, propertyPath);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void initialize(EntityManager em, Object entity, int depth) {
        if (entity == null || depth == 0) {
            return;
        }
        PersistenceUnitUtil unitUtil = em.getEntityManagerFactory().getPersistenceUnitUtil();
        EntityType entityType = em.getMetamodel().entity(entity.getClass());
        Set attributes = entityType.getDeclaredAttributes();
        Object id = unitUtil.getIdentifier(entity);
        if (id != null) {
            Object attached = em.find(entity.getClass(), unitUtil.getIdentifier(entity));
            for (Attribute a : attributes) {
                if (unitUtil.isLoaded(entity, a.getName())) continue;
                if (a.isCollection()) {
                    JpaUtils.intializeCollection(em, entity, attached, a, depth);
                    continue;
                }
                if (!a.isAssociation()) continue;
                JpaUtils.intialize(em, entity, attached, a, depth);
            }
        }
    }

    private static void intialize(EntityManager em, Object entity, Object attached, Attribute a, int depth) {
        Object value = PropertyAccessorFactory.forDirectFieldAccess((Object)attached).getPropertyValue(a.getName());
        if (!em.getEntityManagerFactory().getPersistenceUnitUtil().isLoaded(value)) {
            em.refresh(value);
        }
        PropertyAccessorFactory.forDirectFieldAccess((Object)entity).setPropertyValue(a.getName(), value);
        JpaUtils.initialize(em, value, depth - 1);
    }

    private static void intializeCollection(EntityManager em, Object entity, Object attached, Attribute a, int depth) {
        ConfigurablePropertyAccessor accessor = PropertyAccessorFactory.forDirectFieldAccess((Object)attached);
        Collection c = (Collection)accessor.getPropertyValue(a.getName());
        for (Object o : c) {
            JpaUtils.initialize(em, o, depth - 1);
        }
        PropertyAccessorFactory.forDirectFieldAccess((Object)entity).setPropertyValue(a.getName(), (Object)c);
    }

    public static Set<Attribute<?, ?>> getAttributes(EntityType<?> type, Attribute.PersistentAttributeType persistentType, Class<?> clazz) {
        HashSet attributes = new HashSet();
        for (Attribute a : type.getAttributes()) {
            if (a.getPersistentAttributeType() != persistentType || !JpaUtils.isTypeOrElementType(a, clazz)) continue;
            attributes.add(a);
        }
        return attributes;
    }

    public static Set<Attribute<?, ?>> getAttributes(EntityType<?> type, Attribute.PersistentAttributeType persistentType) {
        return JpaUtils.getAttributes(type, persistentType, Object.class);
    }

    public static boolean isTypeOrElementType(Attribute<?, ?> attribute, Class<?> clazz) {
        if (attribute.isCollection()) {
            return clazz.isAssignableFrom(((CollectionAttribute)attribute).getBindableJavaType());
        }
        return clazz.isAssignableFrom(attribute.getJavaType());
    }

    public static String getMappedBy(Attribute<?, ?> attribute) {
        String mappedBy = null;
        if (attribute.isAssociation()) {
            Annotation[] annotations = null;
            Member member = attribute.getJavaMember();
            if (member instanceof Field) {
                annotations = ((Field)member).getAnnotations();
            } else if (member instanceof Method) {
                annotations = ((Method)member).getAnnotations();
            }
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation a = annotationArray[n2];
                if (a.annotationType().equals(OneToMany.class)) {
                    mappedBy = ((OneToMany)a).mappedBy();
                    break;
                }
                if (a.annotationType().equals(ManyToMany.class)) {
                    mappedBy = ((ManyToMany)a).mappedBy();
                    break;
                }
                if (a.annotationType().equals(OneToOne.class)) {
                    mappedBy = ((OneToOne)a).mappedBy();
                    break;
                }
                ++n2;
            }
        }
        return "".equals(mappedBy) ? null : mappedBy;
    }
}

