/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.cmd;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.cmd.Command;
import org.jdal.cmd.CommandException;
import org.jdal.cmd.Task;

public class DefaultTask
implements Task {
    private static Log log = LogFactory.getLog(DefaultTask.class);
    private boolean stopOnFault = false;
    private List<Command> preProcessors = new LinkedList<Command>();
    private List<Command> postProcessors = new LinkedList<Command>();
    private List<Command> commands = new LinkedList<Command>();
    private String name;

    @Override
    public void addCommand(Command c) {
        this.commands.add(c);
    }

    public void addComand(List<Command> cmdList) {
        this.commands.addAll(cmdList);
    }

    @Override
    public void removeComannd(Command c) {
        if (this.commands.contains(c)) {
            this.commands.remove(c);
        }
    }

    @Override
    public void addPreprocesor(Command c) {
        this.preProcessors.add(c);
    }

    @Override
    public void removePreprocesor(Command c) {
        if (this.preProcessors.contains(c)) {
            this.preProcessors.remove(c);
        }
    }

    @Override
    public void addPostProcessor(Command c) {
        this.postProcessors.add(c);
    }

    @Override
    public void removePostProcessor(Command c) {
        if (this.postProcessors.contains(c)) {
            this.postProcessors.remove(c);
        }
    }

    @Override
    public boolean execute(Object data) {
        boolean result = true;
        for (Command cmd : this.newCommandList()) {
            try {
                cmd.execute(data);
            }
            catch (CommandException ce) {
                log.error((Object)ce);
                this.onFault(ce);
                result = false;
                if (!this.stopOnFault) continue;
                throw ce;
            }
        }
        return result;
    }

    @Override
    public void onFault(Object data) {
        for (Command cmd : this.newCommandList()) {
            cmd.onFault(data);
        }
    }

    public List<Command> newCommandList() {
        LinkedList<Command> list = new LinkedList<Command>();
        list.addAll(this.preProcessors);
        list.addAll(this.commands);
        list.addAll(this.postProcessors);
        return list;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void setCommands(List<Command> commands) {
        this.commands = commands;
    }

    public List<Command> getPostProcessors() {
        return this.postProcessors;
    }

    public void setPostProcessors(List<Command> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public List<Command> getPreProcessors() {
        return this.preProcessors;
    }

    public void setPreProcessors(List<Command> preProcessors) {
        this.preProcessors = preProcessors;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void undo() {
        for (Command cmd : this.newCommandList()) {
            cmd.undo();
        }
    }
}

