/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.beans;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SimpleBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    public static final String SCOPE_ATTRIBUTE = "scope";
    private Class<?> beanClass;

    public SimpleBeanDefinitionParser(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    protected Class<?> getBeanClass(Element element) {
        return this.beanClass;
    }

    protected String getBeanClassName(Element element) {
        if (this.beanClass != null) {
            return this.beanClass.getName();
        }
        return null;
    }

    protected void parseList(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String name) {
        NodeList nl = element.getElementsByTagNameNS(element.getNamespaceURI(), name);
        if (nl.getLength() > 0) {
            Element e = (Element)nl.item(0);
            List actionList = parserContext.getDelegate().parseListElement(e, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue(name, (Object)actionList);
        }
    }

    protected void parseDefaultAttributes(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(SCOPE_ATTRIBUTE)) {
            builder.setScope(element.getAttribute(SCOPE_ATTRIBUTE));
        }
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return super.isEligibleAttribute(attributeName) && !SCOPE_ATTRIBUTE.equals(attributeName);
    }
}

