/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.beans;

import org.apache.commons.lang.StringUtils;
import org.jdal.beans.PropertyUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String DAO_SUFFIX = "Dao";
    private static final String SERVICE_SUFFIX = "Service";
    private static final String JPA_DAO_CLASS_NAME = "org.jdal.dao.jpa.JpaDao";
    private static final String ENTITY = "entity";
    private static final String DAO_CLASS = "dao-class";
    private static final String SERVICE_CLASS = "service-class";
    private static final String PERSISTENT_SERVICE_CLASS_NAME = "org.jdal.logic.PersistentManager";
    private static final String NAME = "name";
    private static final String BUILDER = "builder";
    private static final String CRITERIA = "criteria";
    private static final String CRITERIA_BUILDER_MAP = "criteriaBuilderMap";

    public AbstractBeanDefinition parse(Element element, ParserContext parserContext) {
        String daoClassName = JPA_DAO_CLASS_NAME;
        String serviceClassName = PERSISTENT_SERVICE_CLASS_NAME;
        String name = null;
        boolean declareService = false;
        if (element.hasAttribute(DAO_CLASS)) {
            daoClassName = element.getAttribute(DAO_CLASS);
        }
        if (element.hasAttribute(SERVICE_CLASS)) {
            serviceClassName = element.getAttribute(SERVICE_CLASS);
            declareService = true;
        }
        if (element.hasAttribute(NAME)) {
            name = element.getAttribute(NAME);
        }
        if (element.hasAttribute(ENTITY)) {
            String daoBeanName;
            String className = element.getAttribute(ENTITY);
            if (name == null) {
                name = StringUtils.uncapitalize((String)StringUtils.substringAfterLast((String)className, (String)PropertyUtils.PROPERTY_SEPARATOR));
            }
            parserContext.pushContainingComponent(new CompositeComponentDefinition(name, parserContext.extractSource((Object)element)));
            BeanDefinitionBuilder daoBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)daoClassName);
            NodeList nl = element.getElementsByTagNameNS(element.getNamespaceURI(), CRITERIA);
            if (nl.getLength() > 0) {
                ManagedMap builders = new ManagedMap(nl.getLength());
                int i = 0;
                while (i < nl.getLength()) {
                    Element e = (Element)nl.item(i);
                    builders.put((Object)e.getAttribute(NAME), (Object)new RuntimeBeanReference(e.getAttribute(BUILDER)));
                    ++i;
                }
                daoBuilder.addPropertyValue(CRITERIA_BUILDER_MAP, (Object)builders);
            }
            daoBuilder.addConstructorArgValue((Object)ClassUtils.resolveClassName((String)className, null));
            daoBuilder.setAutowireMode(2);
            if (declareService) {
                daoBeanName = String.valueOf(name) + DAO_SUFFIX;
                this.registerBeanDefinition(parserContext, daoBuilder, daoBeanName);
                String serviceBeanName = String.valueOf(name) + SERVICE_SUFFIX;
                BeanDefinitionBuilder serviceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)serviceClassName);
                serviceBuilder.addPropertyReference("dao", daoBeanName);
                this.registerBeanDefinition(parserContext, serviceBuilder, serviceBeanName);
            } else {
                daoBeanName = String.valueOf(name) + SERVICE_SUFFIX;
                String[] aliases = new String[]{String.valueOf(name) + DAO_SUFFIX};
                BeanComponentDefinition bcd = new BeanComponentDefinition((BeanDefinition)daoBuilder.getBeanDefinition(), daoBeanName, aliases);
                parserContext.registerBeanComponent(bcd);
            }
            parserContext.popAndRegisterContainingComponent();
        }
        return null;
    }

    private void registerBeanDefinition(ParserContext parserContext, BeanDefinitionBuilder builder, String beanName) {
        BeanComponentDefinition bcd = new BeanComponentDefinition((BeanDefinition)builder.getBeanDefinition(), beanName);
        parserContext.registerBeanComponent(bcd);
    }
}

