/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.beans;

import java.beans.PropertyDescriptor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.jdal.util.BeanUtils;

public abstract class PropertyUtils {
    public static String PROPERTY_SEPARATOR = ".";

    public static String getPropertyName(String propertyPath) {
        if (propertyPath.contains(PROPERTY_SEPARATOR)) {
            return StringUtils.substringAfterLast((String)propertyPath, (String)PROPERTY_SEPARATOR);
        }
        return propertyPath;
    }

    public static String getPath(String propertyPath) {
        return StringUtils.substringBeforeLast((String)propertyPath, (String)PROPERTY_SEPARATOR);
    }

    public static boolean isNested(String propertyPath) {
        return propertyPath.contains(PROPERTY_SEPARATOR);
    }

    public static String getFirstPropertyName(String propertyPath) {
        return PropertyUtils.isNested(propertyPath) ? StringUtils.substringBefore((String)propertyPath, (String)PROPERTY_SEPARATOR) : propertyPath;
    }

    public static String getNestedPath(String propertyPath) {
        return StringUtils.substringAfter((String)propertyPath, (String)PROPERTY_SEPARATOR);
    }

    public static String toHumanReadable(String propertyName) {
        String humanReadable = PropertyUtils.getPropertyName(propertyName).replaceAll("([A-Z])", " $1").trim();
        return WordUtils.capitalize((String)humanReadable);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyPath) {
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(clazz, (String)PropertyUtils.getFirstPropertyName(PropertyUtils.getFirstPropertyName(propertyPath)));
        if (PropertyUtils.isNested(propertyPath)) {
            return PropertyUtils.getPropertyDescriptor(pd.getPropertyType(), PropertyUtils.getNestedPath(propertyPath));
        }
        return pd;
    }
}

