/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.beans;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageSourceWrapper
implements MessageSource,
Serializable {
    private static final Log log = LogFactory.getLog(MessageSourceWrapper.class);
    private MessageSource messageSource;

    public MessageSourceWrapper() {
    }

    public MessageSourceWrapper(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getMessage(String code) {
        try {
            return this.messageSource == null ? code : this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException nsme) {
            log.error((Object)nsme);
            return code;
        }
    }

    public String getMessage(MessageSourceResolvable msr) {
        return this.messageSource == null ? msr.getDefaultMessage() : this.messageSource.getMessage(msr, LocaleContextHolder.getLocale());
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getMessage(String code, Object[] args) {
        return this.getMessage(code, args, "", LocaleContextHolder.getLocale());
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.messageSource == null ? code : this.messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.messageSource == null ? code : this.messageSource.getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.messageSource == null ? resolvable.getDefaultMessage() : this.messageSource.getMessage(resolvable, locale);
    }

    public boolean hasMessage(String code) {
        if (this.messageSource == null) {
            return false;
        }
        try {
            this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale());
            return true;
        }
        catch (NoSuchMessageException nsme) {
            return false;
        }
    }
}

