/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.audit;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.jdal.audit.AbstractAuditor;
import org.jdal.audit.Auditable;

public class Auditor
extends AbstractAuditor {
    private static final Log LOG = LogFactory.getLog(Auditor.class);

    @Override
    public Object audit(ProceedingJoinPoint pjp) throws Throwable {
        LOG.debug((Object)("Auditing on method: " + pjp.toShortString()));
        Object result = pjp.proceed();
        if (pjp.getTarget() instanceof Auditable) {
            Auditable auditable = (Auditable)pjp.getTarget();
            this.audit(auditable);
        } else {
            LOG.warn((Object)"Tried to audit a non-auditable object. Check your AOP configuration on applicationContext.xml");
        }
        return result;
    }

    protected void audit(Auditable auditable) {
        Date date = new Date();
        auditable.setModificationDate(date);
        auditable.setModificationUser("testUser");
    }
}

