/*
 * Copyright 2009-2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jdal.dao.jpa;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;

import org.jdal.dao.Filter;

/**
 * @author Jose Luis Martin - (jlm@joseluismartin.info)
 *
 */
public interface JpaCriteriaBuilder<T> {
	/**
	 * Add Restrictions to Critera from filter
	 * @param criteria criteria to add restrictions
	 * @param filter Filter data
	 * @param cb CriteriaBuilder
	 * @return criteria.
	 */
	CriteriaQuery<T>  build(CriteriaQuery<T> criteria, CriteriaBuilder cb, Filter filter);

}


