/*
 * Copyright 2009-2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jdal.annotations;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Mark a field or property as reference of other by
 * type or property
 * 
 * @author Jose Luis Martin - (jlm@joseluismartin.info)
 */
@Target({METHOD, FIELD}) 
@Retention(RUNTIME)
@SuppressWarnings("rawtypes")
public @interface Reference {
	
	/** 
     * (Optional) The entity class that is the target of 
     * the association. 
     *
     * <p> Defaults to the type of the field or property 
     * that stores the association. 
     */
   
	Class target() default void.class;
    
    /**
     * (Optional) The name of the property.
     * <p> Defaults to type or property that stores the
     * association.
     */
    String property() default "";
	
}
