/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.xml;

import info.joseluismartin.xml.XMLMapper;
import info.joseluismartin.xml.XMLMappingException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;

public class JibXXMLMapper
implements XMLMapper {
    private Log log = LogFactory.getLog(XMLMapper.class);
    private String bindingName = "";
    private String packageName = "";

    public Object deserialize(String xml) {
        IBindingFactory bfact = null;
        StringReader sr = new StringReader(xml);
        Object obj = null;
        try {
            bfact = BindingDirectory.getFactory((String)this.bindingName, (String)this.packageName);
            obj = bfact.createUnmarshallingContext().unmarshalDocument((Reader)sr);
        }
        catch (JiBXException e) {
            this.log.error((Object)e);
            throw new XMLMappingException("Can't deserialize xml: " + xml, e);
        }
        return obj;
    }

    public String serialize(Object obj) {
        IBindingFactory bfact = null;
        StringWriter sw = new StringWriter();
        try {
            bfact = BindingDirectory.getFactory(obj.getClass());
            bfact.createMarshallingContext().marshalDocument(obj, "UTF-8", null, (Writer)sw);
        }
        catch (JiBXException e) {
            this.log.error((Object)e);
            throw new XMLMappingException("Can't serialize object: " + obj.toString(), e);
        }
        return sw.toString();
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

