/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.util.processor;

import info.joseluismartin.util.processor.FileProcessor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRXlsExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasperReportXMLFileProcessor
implements FileProcessor {
    private byte[] rawData;
    private Connection conn;
    private JRDataSource service;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    @Override
    public void processFile(File file, String outputType, boolean hasQuery) {
        FileInputStream reportStream = null;
        try {
            reportStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)reportStream);
            JasperPrint jasperPrint = null;
            jasperPrint = hasQuery ? JasperFillManager.fillReport((JasperReport)jasperReport, this.parameters, (Connection)this.conn) : JasperFillManager.fillReport((JasperReport)jasperReport, this.parameters, (JRDataSource)this.service);
            byte[] reportBin = null;
            if ("pdf".equals(outputType)) {
                reportBin = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
            } else if ("xls".equals(outputType)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                JRXlsExporter exporter = new JRXlsExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
                exporter.exportReport();
                reportBin = baos.toByteArray();
            }
            this.setRawData(reportBin);
        }
        catch (JRException e) {
            System.out.println("Error processing report: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    @Override
    public void processFile(byte[] rawData) {
    }

    @Override
    public byte[] getRawData() {
        return this.rawData;
    }

    public void setRawData(byte[] rawData) {
        this.rawData = rawData;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void setService(JRDataSource source) {
        this.service = source;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }
}

