/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.util.processor;

import info.joseluismartin.util.processor.FileProcessor;
import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasperReportFileProcessor
implements FileProcessor {
    private byte[] rawData;
    private Connection conn;
    private JRDataSource service;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public JasperReportFileProcessor() {
    }

    public JasperReportFileProcessor(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void processFile(File file, String outputType, boolean hasQuery) {
        try {
            JasperPrint print = null;
            print = hasQuery ? JasperFillManager.fillReport((InputStream)new FileInputStream(file), this.parameters, (Connection)this.conn) : JasperFillManager.fillReport((InputStream)new FileInputStream(file), this.parameters, (JRDataSource)this.service);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JRPdfExporter exporter = new JRPdfExporter();
            if ("pdf".equals(outputType)) {
                exporter = new JRPdfExporter();
            } else if ("xls".equals(outputType)) {
                exporter = new JRXlsExporter();
            }
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
            exporter.exportReport();
            this.setRawData(baos.toByteArray());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processFile(byte[] rawData) {
    }

    public void setRawData(byte[] data) {
        this.rawData = data;
    }

    @Override
    public byte[] getRawData() {
        return this.rawData;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public static void main(String[] args) {
        try {
            JasperReport report = JasperCompileManager.compileReport((String)"/home/jose/Projects/telmma/Documents/Code/testParameters.jrxml");
            System.out.println("Query en el jasper: " + report.getQuery().getText());
            for (JRParameter param : report.getParameters()) {
                if (param.isSystemDefined()) continue;
                System.out.println(param.getName());
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("NombreCiudad", "Huelva");
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, parameters, (JRDataSource)new JREmptyDataSource());
            byte[] reportBin = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    File outputFile = File.createTempFile("simple_report", ".pdf");
                    FileUtils.writeByteArrayToFile((File)outputFile, (byte[])reportBin);
                    System.out.println("OutputFile -> " + outputFile.getName() + " " + outputFile.getTotalSpace());
                    desktop.open(outputFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setService(JRDataSource service) {
        this.service = service;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }
}

