/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyValue;

public abstract class BeanUtils
extends org.springframework.beans.BeanUtils {
    private static Log log = LogFactory.getLog(BeanUtils.class);
    private static final String[] EXCLUDED_PROPERTIES = new String[]{"class"};

    public static PropertyValue[] getPropertyValues(Object obj) {
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(obj.getClass());
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        List<String> excludedProperties = Arrays.asList(EXCLUDED_PROPERTIES);
        for (int i = 0; i < pds.length; ++i) {
            Object value = null;
            String name = pds[i].getName();
            if (excludedProperties.contains(name)) continue;
            try {
                value = pds[i].getReadMethod().invoke(obj, (Object[])null);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Error reading property name: " + name), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Error reading property name: " + name), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)("Error reading property name: " + name), (Throwable)e);
            }
            pvs.add(new PropertyValue(name, value));
        }
        return pvs.toArray(new PropertyValue[pvs.size()]);
    }

    public static void copyProperty(Object source, Object dest, String propertyName) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(source);
        PropertyValue pv = new PropertyValue(propertyName, wrapper.getPropertyValue(propertyName));
        wrapper.setPropertyValue(pv);
    }

    public static void setProperty(Object bean, String name, Object value) {
        try {
            BeanWrapperImpl wrapper = new BeanWrapperImpl(bean);
            wrapper.setPropertyValue(new PropertyValue(name, value));
        }
        catch (InvalidPropertyException ipe) {
            log.debug((Object)("Bean has no property: " + name));
        }
        catch (PropertyAccessException pae) {
            log.debug((Object)("Access Error on property: " + name));
        }
    }

    public static Object getProperty(Object bean, String name) {
        try {
            BeanWrapperImpl wrapper = new BeanWrapperImpl(bean);
            return wrapper.getPropertyValue(name);
        }
        catch (PropertyAccessException pae) {
            return null;
        }
    }
}

