/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.system;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SystemUtils {
    private static final Log log = LogFactory.getLog(SystemUtils.class);

    public static void open(byte[] data, String extension) {
        if (data != null && Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                File file = File.createTempFile("tmp", "." + extension);
                file.deleteOnExit();
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                desktop.open(file);
            }
            catch (IOException e) {
                String message = "No ha sido posible abrir el fichero";
                JOptionPane.showMessageDialog(null, message, "Error de datos", 0);
            }
        }
    }

    public static void open(File file) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    public static byte[] getFileAsByteArray() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        if (0 == chooser.showOpenDialog(null)) {
            File file = chooser.getSelectedFile();
            try {
                return FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        return null;
    }
}

