/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.service;

import info.joseluismartin.dao.Dao;
import info.joseluismartin.dao.DaoFactory;
import info.joseluismartin.logic.PersistentManager;
import info.joseluismartin.service.PersistentService;
import java.io.Serializable;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.MatchAlwaysTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentServiceFactory {
    @Autowired
    private DaoFactory daoFactory;
    @Autowired
    private PlatformTransactionManager transactionManager;

    public <T> PersistentService<T, Serializable> createPersistentService(Class<T> clazz) {
        Dao<T, Serializable> dao = this.daoFactory.createDao(clazz);
        PersistentManager<T, Serializable> manager = new PersistentManager<T, Serializable>();
        manager.setDao(dao);
        return this.makeTransactionalProxy(manager);
    }

    public <T> PersistentService<T, Serializable> makeTransactionalProxy(PersistentService<T, Serializable> service) {
        ProxyFactory factory = new ProxyFactory(service);
        factory.setInterfaces(new Class[]{PersistentService.class});
        TransactionInterceptor interceptor = new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)new MatchAlwaysTransactionAttributeSource());
        factory.addAdvice((Advice)interceptor);
        factory.setTarget(service);
        return (PersistentService)factory.getProxy();
    }
}

