/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.reporting;

import info.joseluismartin.reporting.ReportType;
import info.joseluismartin.util.ZipFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipFile;
import javax.persistence.Column;
import javax.persistence.Id;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Report {
    private static final Log log = LogFactory.getLog(Report.class);
    private Long id;
    private String name;
    private ReportType type;
    private String fileName;
    private byte[] data;
    private String description;
    private Boolean hasQuery;

    public JasperReport newJasperReport() {
        String suffix = FilenameUtils.getExtension((String)this.getFileName());
        String prefix = FilenameUtils.getBaseName((String)this.getFileName());
        JasperReport jasperReport = null;
        try {
            File file = File.createTempFile(prefix, "." + suffix);
            FileUtils.writeByteArrayToFile((File)file, (byte[])this.data);
            if ("zip".equalsIgnoreCase(suffix)) {
                String dir = System.getProperty("java.io.tmpdir") + "/" + prefix;
                ZipFileUtils.unzip(new ZipFile(file), dir);
                File dirFile = new File(dir);
                Iterator iter = FileUtils.iterateFiles((File)dirFile, (String[])new String[]{"jrxml", "jasper"}, (boolean)false);
                if (iter.hasNext()) {
                    file = (File)iter.next();
                }
            }
            suffix = FilenameUtils.getExtension((String)file.getName());
            FileInputStream reportStream = new FileInputStream(file);
            if ("jrxml".equalsIgnoreCase(suffix)) {
                jasperReport = JasperCompileManager.compileReport((InputStream)reportStream);
            } else if ("jasper".equalsIgnoreCase(suffix)) {
                jasperReport = (JasperReport)JRLoader.loadObject((InputStream)reportStream);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return jasperReport;
    }

    @Id
    public Long getId() {
        return this.id;
    }

    @Column(name="nombre")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ReportType getType() {
        return this.type;
    }

    public void setType(ReportType type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setFile(File file) throws IOException {
        this.data = FileUtils.readFileToByteArray((File)file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getHasQuery() {
        return this.hasQuery;
    }

    public void setHasQuery(Boolean hasQuery) {
        this.hasQuery = hasQuery;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Report other = (Report)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

