/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.mock;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockReplacer
implements BeanFactoryPostProcessor {
    private Log log = LogFactory.getLog(MockReplacer.class);
    private Map<String, Object> replacedBeans = new HashMap<String, Object>();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        for (String name : this.replacedBeans.keySet()) {
            Object bean = this.replacedBeans.get(name);
            this.log.debug((Object)("Replacing Bean " + name + " with instance of class " + bean.getClass()));
            factory.registerSingleton(name, bean);
        }
    }

    public final void add(String name, Object obj) {
        this.replacedBeans.put(name, obj);
    }

    public Map<String, Object> getReplacedBeans() {
        return this.replacedBeans;
    }

    public void setReplacedBeans(Map<String, Object> replacedBeans) {
        this.replacedBeans = replacedBeans;
    }
}

