/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.mock;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.easymock.EasyMock;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMockReplacer
implements BeanFactoryPostProcessor {
    private List<Class<?>> replacedClasses = new ArrayList();
    private Log log = LogFactory.getLog(EasyMockReplacer.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        for (Class<?> clazz : this.replacedClasses) {
            this.replaceBean(clazz, factory);
        }
    }

    private void replaceBean(Class<?> clazz, ConfigurableListableBeanFactory factory) {
        String[] names;
        Object mock = EasyMock.createMock(clazz);
        for (String name : names = factory.getBeanNamesForType(clazz)) {
            this.log.info((Object)("Registering bean " + name + " with mock " + clazz.getName()));
            factory.registerSingleton(name, mock);
        }
    }

    public boolean add(Class<?> clazz) {
        return this.replacedClasses.add(clazz);
    }

    public boolean remove(Class<?> clazz) {
        return this.replacedClasses.remove(clazz);
    }
}

