/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.logic;

import info.joseluismartin.dao.Dao;
import info.joseluismartin.dao.Page;
import info.joseluismartin.service.PersistentService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentManager<T, PK extends Serializable>
implements PersistentService<T, PK> {
    private static final Log log = LogFactory.getLog(PersistentManager.class);
    public static final int DEFAULT_DEPTH = 2;
    protected Dao<T, PK> dao;

    @Override
    public void delete(T entity) {
        this.dao.delete(entity);
    }

    @Override
    public T initialize(T entity, int depth) {
        this.dao.initialize(entity, depth);
        return entity;
    }

    @Override
    public T initialize(T entity) {
        this.dao.initialize(entity);
        return entity;
    }

    @Override
    public List<T> getAll() {
        return this.dao.getAll();
    }

    @Override
    public T save(T entity) {
        return this.dao.save(entity);
    }

    @Override
    public void delete(Collection<T> collection) {
        for (T t : collection) {
            this.dao.delete(t);
        }
    }

    @Override
    public Collection<T> save(Collection<T> collection) {
        ArrayList<T> saved = new ArrayList<T>();
        for (T t : collection) {
            saved.add(this.dao.save(t));
        }
        return saved;
    }

    @Override
    public void deleteById(PK id) {
        this.dao.deleteById(id);
    }

    @Override
    public void deleteById(Collection<PK> ids) {
        for (Serializable id : ids) {
            this.dao.deleteById(id);
        }
    }

    @Override
    public List<Serializable> getKeys(Page<T> page) {
        return this.dao.getKeys(page);
    }

    @Override
    public Page<T> getPage(Page<T> page) {
        return this.dao.getPage(page);
    }

    public Dao<T, PK> getDao() {
        return this.dao;
    }

    public void setDao(Dao<T, PK> dao) {
        this.dao = dao;
    }

    @Override
    public T get(PK id) {
        return this.dao.get(id);
    }

    @Override
    public <E> E get(PK id, Class<E> clazz) {
        return this.dao.get(id, clazz);
    }

    @Override
    public <E> List<E> getAll(Class<E> clazz) {
        return this.dao.getAll(clazz);
    }
}

