/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.hibernate.aop;

import info.joseluismartin.dao.hibernate.HibernateDao;
import info.joseluismartin.hibernate.aop.SessionProcessor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAspect {
    private static final Log log = LogFactory.getLog(SessionAspect.class);
    private List<SessionProcessor> sessionProcessors;
    private SessionFactory sessionFactory;

    public void processSession(JoinPoint jp) {
        if (log.isDebugEnabled()) {
            String entityClassName = "";
            Object target = jp.getTarget();
            if (target instanceof HibernateDao) {
                entityClassName = ((HibernateDao)target).getEntityClass().getSimpleName();
            }
            log.debug((Object)("Advising: " + jp.toShortString() + " of class: " + jp.getTarget().getClass().getSimpleName() + "<" + entityClassName + ">"));
        }
        try {
            Session session = this.sessionFactory.getCurrentSession();
            for (SessionProcessor sp : this.sessionProcessors) {
                sp.processSession((org.hibernate.Session)session);
            }
        }
        catch (HibernateException he) {
            log.error((Object)he);
        }
    }

    public List<SessionProcessor> getSessionProcessors() {
        return this.sessionProcessors;
    }

    public void setSessionProcessors(List<SessionProcessor> sessionProcessors) {
        this.sessionProcessors = sessionProcessors;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

