/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gis.google;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;

public class RouteRequest {
    private Point origin;
    private Point destination;
    private Mode mode = Mode.DRIVING;
    private String language = "es";

    public RouteRequest() {
    }

    public RouteRequest(Point origin, Point destination) {
        this.origin = origin;
        this.destination = destination;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("origin=");
        sb.append(this.origin.getX());
        sb.append(",");
        sb.append(this.origin.getY());
        sb.append("&");
        sb.append("destination=");
        sb.append(this.destination.getX());
        sb.append(",");
        sb.append(this.destination.getY());
        sb.append("&");
        sb.append("language=");
        sb.append(this.language);
        sb.append("&");
        sb.append("sensor=false");
        return sb.toString();
    }

    private Point getPoint(double lat, double lon) {
        Coordinate coordinate = new Coordinate(lat, lon);
        CoordinateArraySequence coordinates = new CoordinateArraySequence(new Coordinate[]{coordinate});
        return new Point((CoordinateSequence)coordinates, new GeometryFactory(new PrecisionModel(), 4326));
    }

    public Point getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point origin) {
        this.origin = origin;
    }

    public Point getDestination() {
        return this.destination;
    }

    public void setDestination(Point destination) {
        this.destination = destination;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setOrigin(double lat, double lon) {
        this.origin = this.getPoint(lat, lon);
    }

    public void setDestination(double lat, double lon) {
        this.destination = this.getPoint(lat, lon);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        DRIVING,
        WALKING,
        BICYCLING;

    }
}

