/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.dao.jpa;

import info.joseluismartin.beans.PropertyUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaUtils {
    private static String ALIAS_PATTERN_STRING = "(?<=from)\\s+(?:\\S+)\\s+(?:as\\s+)*(\\w*)";
    private static Pattern ALIAS_PATTERN = Pattern.compile(ALIAS_PATTERN_STRING, 2);
    private static String FROM_PATTERN_STRING = "(from.*+)";
    private static Pattern FROM_PATTERN = Pattern.compile(FROM_PATTERN_STRING, 2);
    private static volatile long aliasCount = 0L;

    public static <T> Long count(EntityManager em, CriteriaQuery<T> criteria) {
        return (Long)em.createQuery(JpaUtils.countCriteria(em, criteria)).getSingleResult();
    }

    public static <T> CriteriaQuery<Long> countCriteria(EntityManager em, CriteriaQuery<T> criteria) {
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery countCriteria = builder.createQuery(Long.class);
        JpaUtils.copyCriteriaNoSelection(criteria, countCriteria);
        countCriteria.select((Selection)builder.count(JpaUtils.findRoot(countCriteria, criteria.getResultType())));
        return countCriteria;
    }

    public static synchronized <T> String getOrCreateAlias(Selection<T> selection) {
        String alias;
        if (aliasCount > 1000L) {
            aliasCount = 0L;
        }
        if ((alias = selection.getAlias()) == null) {
            alias = "JDAL_generatedAlias" + aliasCount++;
            selection.alias(alias);
        }
        return alias;
    }

    public static <T> Root<T> findRoot(CriteriaQuery<T> query) {
        return JpaUtils.findRoot(query, query.getResultType());
    }

    public static <T> Root<T> findRoot(CriteriaQuery<?> query, Class<T> clazz) {
        for (Root r : query.getRoots()) {
            if (!clazz.equals(r.getJavaType())) continue;
            return (Root)r.as(clazz);
        }
        return null;
    }

    public static <T, K> Join<T, K> findJoinedType(CriteriaQuery<T> query, Class<T> rootClass, Class<K> joinClass) {
        Root<T> root = JpaUtils.findRoot(query, rootClass);
        Join join = null;
        for (Join j : root.getJoins()) {
            if (!j.getJoinType().equals(joinClass)) continue;
            join = j;
        }
        return join;
    }

    public static Path<?> getPath(Path<?> path, String propertyPath) {
        if (StringUtils.isEmpty((String)propertyPath)) {
            return path;
        }
        String name = StringUtils.substringBefore((String)propertyPath, (String)PropertyUtils.PROPERTY_SEPARATOR);
        Path p = path.get(name);
        return JpaUtils.getPath(p, StringUtils.substringAfter((String)propertyPath, (String)PropertyUtils.PROPERTY_SEPARATOR));
    }

    public static String createCountQueryString(String queryString) {
        return queryString.replaceFirst("^.*(?i)from", "select count (*) from ");
    }

    public static String getAlias(String queryString) {
        Matcher m = ALIAS_PATTERN.matcher(queryString);
        return m.find() ? m.group(1) : null;
    }

    public static String addOrder(String queryString, String propertyPath, boolean asc) {
        if (StringUtils.containsIgnoreCase((String)queryString, (String)"order by")) {
            return queryString;
        }
        StringBuilder sb = new StringBuilder(queryString);
        sb.append(" ORDER BY ");
        sb.append(JpaUtils.getAlias(queryString));
        sb.append(".");
        sb.append(propertyPath);
        sb.append(" ");
        sb.append(asc ? "ASC" : "DESC");
        return sb.toString();
    }

    public static String getKeyQuery(String queryString, String name) {
        Matcher m = FROM_PATTERN.matcher(queryString);
        if (m.find()) {
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append(JpaUtils.getAlias(queryString));
            sb.append(".");
            sb.append(name);
            sb.append(" ");
            sb.append(m.group());
            return sb.toString();
        }
        return null;
    }

    public static void copyCriteriaNoSelection(CriteriaQuery<?> from, CriteriaQuery<?> to) {
        for (Root root : from.getRoots()) {
            Root dest = to.from(root.getJavaType());
            dest.alias(JpaUtils.getOrCreateAlias(root));
            JpaUtils.copyJoins(root, dest);
        }
        to.groupBy(from.getGroupList());
        to.distinct(from.isDistinct());
        to.having((Expression)from.getGroupRestriction());
        to.where((Expression)from.getRestriction());
        to.orderBy(from.getOrderList());
    }

    public static <T> void copyCriteria(CriteriaQuery<T> from, CriteriaQuery<T> to) {
        JpaUtils.copyCriteriaNoSelection(from, to);
        to.select(from.getSelection());
    }

    public static void copyJoins(From<?, ?> from, From<?, ?> to) {
        for (Join j : from.getJoins()) {
            Join toJoin = to.join(j.getAttribute().getName(), j.getJoinType());
            toJoin.alias(JpaUtils.getOrCreateAlias(j));
            JpaUtils.copyJoins(j, toJoin);
        }
        for (Fetch f : from.getFetches()) {
            Fetch toFetch = to.fetch(f.getAttribute().getName());
            JpaUtils.copyFetches(f, toFetch);
        }
    }

    public static void copyFetches(Fetch<?, ?> from, Fetch<?, ?> to) {
        for (Fetch f : from.getFetches()) {
            Fetch toFetch = to.fetch(f.getAttribute().getName());
            JpaUtils.copyFetches(f, toFetch);
        }
    }
}

