/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.dao.ibatis;

import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import info.joseluismartin.dao.Dao;
import info.joseluismartin.dao.Page;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBatisDao<T, PK extends Serializable>
extends SqlMapClientDaoSupport
implements Dao<T, PK> {
    private static final String PRIMARY_KEY_PROPERTY_NAME = "id";
    private Class<T> entityClass;

    @Override
    public Page<T> getPage(Page<T> page) {
        String queryName = this.getSelectQuery();
        Object queryPage = page;
        if (page.getSortName() != null) {
            queryPage = page.clone();
            ((Page)queryPage).setSortName(this.getColumnName(page.getSortName()));
        }
        List result = this.getSqlMapClientTemplate().queryForList(queryName, queryPage, page.getStartIndex(), page.getPageSize());
        String countQueryName = queryName + "Count";
        int count = (Integer)this.getSqlMapClientTemplate().queryForObject(countQueryName, page);
        page.setData(result);
        page.setCount(count);
        return page;
    }

    private String getColumnName(String sortName) {
        SqlMapClientImpl impl = (SqlMapClientImpl)this.getSqlMapClient();
        ResultMap result = impl.delegate.getResultMap(this.getEntityName() + "." + this.getEntityName());
        for (ResultMapping mapping : result.getResultMappings()) {
            if (!mapping.getPropertyName().equals(sortName)) continue;
            return mapping.getColumnName();
        }
        return null;
    }

    @Override
    public T save(T entity) {
        int i = (Integer)this.getPrimaryKey(entity);
        if (i == 0) {
            this.insert(entity);
        } else {
            this.update(entity);
        }
        return entity;
    }

    public PK insert(T entity) {
        return (PK)((Serializable)this.getSqlMapClientTemplate().insert(this.getInsertQuery(), entity));
    }

    public void update(T entity) {
        this.getSqlMapClientTemplate().update(this.getUpdateQuery(), entity);
    }

    protected PK getPrimaryKey(T entity) {
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(entity);
        return (PK)((Serializable)bw.getPropertyValue(this.getPrimaryKeyPropertyName()));
    }

    protected String getPrimaryKeyPropertyName() {
        return PRIMARY_KEY_PROPERTY_NAME;
    }

    @Override
    public void delete(T entity) {
        this.deleteById(this.getPrimaryKey(entity));
    }

    @Override
    public void deleteById(PK id) {
    }

    @Override
    public T get(PK id) throws DataAccessException {
        Object entity = this.getSqlMapClientTemplate().queryForObject(this.getByIdQuery(), id);
        return (T)entity;
    }

    @Override
    public List<T> getAll() throws DataAccessException {
        return this.getSqlMapClientTemplate().queryForList(this.getSelectQuery());
    }

    private String getSelectQuery() {
        return "select" + this.getEntityName();
    }

    private String getByIdQuery() {
        return "get" + this.getEntityName();
    }

    protected String getInsertQuery() {
        return "insert" + this.getEntityName();
    }

    protected String getValidateDuplicateQuery() {
        return "validateDuplicates" + this.getEntityName();
    }

    protected String getUpdateQuery() {
        return "update" + this.getEntityName();
    }

    protected String getDeleteQuery() {
        return "delete" + this.getEntityName();
    }

    protected String getNewIdQuery() {
        return "newId" + this.getEntityName();
    }

    protected String getEntityName() {
        return ClassUtils.getShortClassName(this.entityClass);
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public boolean exists(PK id) {
        return false;
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        return null;
    }

    public List<T> getAllDistinct() {
        return null;
    }

    public void remove(PK id) {
    }

    @Override
    public List<Serializable> getKeys(Page<T> page) {
        return null;
    }

    @Override
    public T initialize(T entity) {
        return entity;
    }

    @Override
    public T initialize(T entity, int depth) {
        return entity;
    }

    @Override
    public <E> E get(PK id, Class<E> clazz) {
        return null;
    }

    @Override
    public <E> List<E> getAll(Class<E> clazz) {
        return null;
    }
}

