/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.dao;

import info.joseluismartin.dao.PageChangedEvent;
import info.joseluismartin.dao.PageableDataSource;
import info.joseluismartin.dao.Paginator;
import info.joseluismartin.dao.PaginatorListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page<T>
implements Paginator,
Cloneable,
Serializable {
    private static final Log log = LogFactory.getLog(Page.class);
    private List<T> data = new ArrayList<T>();
    private int count;
    private int pageSize;
    private String sortName;
    private Order order;
    private Object filter;
    private int page = 1;
    private PageableDataSource<T> pageableDataSource;
    private ArrayList<PaginatorListener> listeners = new ArrayList();

    public Page(int pageSize, int page, String sortName, Order order) {
        this.pageSize = pageSize;
        if (page > 0) {
            this.page = page;
        }
        this.sortName = sortName;
        this.order = order;
    }

    public Page(int pageSize, int page, String sortName) {
        this(pageSize, page, sortName, Order.ASC);
    }

    public Page(int pageSize, int page) {
        this(pageSize, page, null);
    }

    public Page(int pageSize) {
        this(pageSize, 1);
    }

    public Page() {
        this(10);
    }

    public List<T> getData() {
        return this.data;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    public String getSortName() {
        return this.sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public void setOrderAsc() {
        this.setOrder(Order.ASC);
    }

    public void setOrderDesc() {
        this.setOrder(Order.DESC);
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        this.filter = filter;
    }

    public Page<T> clone() {
        try {
            return (Page)super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)e);
            return null;
        }
    }

    public PageableDataSource<T> getPageableDataSource() {
        return this.pageableDataSource;
    }

    @Override
    public boolean hasNext() {
        return this.page < this.getTotalPages();
    }

    @Override
    public boolean hasPage(int indexPage) {
        return indexPage <= this.getTotalPages() && indexPage > 0;
    }

    @Override
    public boolean hasPrevious() {
        return this.page > 1;
    }

    @Override
    public void setPage(int indexPage) {
        if (indexPage > 0) {
            this.page = indexPage;
            this.load();
            this.firePageChangedEvent();
        } else {
            log.warn((Object)"Try to set a page < 1");
        }
    }

    @Override
    public int getStartIndex() {
        return (this.page - 1) * this.pageSize;
    }

    @Override
    public int getTotalPages() {
        if (this.pageSize > 0) {
            return (int)Math.ceil(this.count / this.pageSize) + (this.count % this.pageSize == 0 ? 0 : 1);
        }
        return 1;
    }

    @Override
    public void addPaginatorListener(PaginatorListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removePaginatorListener(PaginatorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        if (pageSize > 0) {
            this.page = (int)Math.ceil(this.getStartIndex() / pageSize) + 1;
            this.pageSize = pageSize;
            this.firePageChangedEvent();
        }
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void firstPage() {
        this.setPage(1);
    }

    @Override
    public void lastPage() {
        this.setPage(this.getTotalPages());
    }

    @Override
    public void nextPage() {
        this.setPage(this.page + 1);
    }

    @Override
    public void previousPage() {
        this.setPage(this.page - 1);
    }

    private void firePageChangedEvent() {
        for (PaginatorListener listener : this.listeners) {
            listener.pageChanged(new PageChangedEvent(this, this.page, this.getStartIndex(), this.getTotalPages(), this.pageSize));
        }
    }

    public void load() {
        if (this.pageableDataSource != null) {
            this.pageableDataSource.getPage(this);
        }
    }

    public void setPageableDataSource(PageableDataSource<T> pageableDataSource) {
        this.pageableDataSource = pageableDataSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        ASC,
        DESC;

    }
}

