/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.dao;

import info.joseluismartin.dao.Filter;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFilter
implements Filter,
Serializable {
    private static final Log log = LogFactory.getLog(BeanFilter.class);
    private String filterName;
    private List<String> ignoredProperties = new ArrayList<String>();
    private static final String PARAMETER_MAP = "parameterMap";
    private static final String FILTER_NAME = "filterName";

    public BeanFilter() {
        this(BeanFilter.class.getSimpleName());
    }

    public BeanFilter(String filterName) {
        this.filterName = filterName;
        this.ignoredProperties.add(PARAMETER_MAP);
        this.ignoredProperties.add(FILTER_NAME);
        this.ignoredProperties.add("class");
    }

    @Override
    public Map<String, Object> getParameterMap() {
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(this.getClass());
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (PropertyDescriptor pd : pds) {
            if (this.ignoredProperties.contains(pd.getName())) continue;
            try {
                map.put(pd.getName(), pd.getReadMethod().invoke((Object)this, (Object[])null));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return map;
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String name) {
        this.filterName = name;
    }
}

