/*
 * Copyright 2008-2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package info.joseluismartin.logic;

import info.joseluismartin.dao.ReportDao;
import info.joseluismartin.reporting.Report;
import info.joseluismartin.reporting.ReportType;
import info.joseluismartin.service.ReportService;

import java.util.List;

/**
 * Report Serivice Implementation
 * 
 * @author Jose Luis Martin - (jlm@joseluismartin.info)
 */
public class ReportManager extends PersistentManager<Report, Long> implements ReportService {

	protected ReportDao dao;
	

	public List<Report> getReportsByType(ReportType type) {
		if (type == null) return getAll();
		return dao.getReportsByType(type);
	}

	public ReportDao getReporDao() {
		return dao;
	}

	public void setReportDao(ReportDao dao) {
		this.dao = dao;
	}
}
