/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.aop;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.aop.SerializableProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SerializableReference
implements Serializable {
    private static final Log log = LogFactory.getLog(SerializableReference.class);
    private static final Map<String, Object> serializedObjects = new ConcurrentHashMap<String, Object>();
    private boolean proxyTargetClass;
    private boolean useMemoryCache;
    private DependencyDescriptor descriptor;
    private ConfigurableListableBeanFactory beanFactory;
    private String id;
    private String beanName;
    private transient Object target;
    private String targetBeanName;

    public SerializableReference() {
    }

    public SerializableReference(Object target, boolean proxyTargetClass, boolean useMemoryCache, ConfigurableListableBeanFactory beanFactory, DependencyDescriptor descriptor, String beanName) {
        this.proxyTargetClass = proxyTargetClass;
        this.useMemoryCache = useMemoryCache;
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.descriptor = descriptor;
        this.target = target;
    }

    public SerializableReference(Object target, boolean proxyTargetClass, boolean useMemoryCache, ConfigurableListableBeanFactory beanFactory, String targetBeanName) {
        this(target, proxyTargetClass, useMemoryCache, beanFactory, null, null);
        this.targetBeanName = targetBeanName;
    }

    public void serialize() {
        if (this.useMemoryCache) {
            this.id = ObjectUtils.identityToString((Object)this.target);
            serializedObjects.put(this.id, this.target);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added new serialized reference. serialized objects size [" + serializedObjects.size() + "]"));
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        PropertyValue value;
        Object ret;
        if (this.beanFactory == null) {
            log.error((Object)"Can't not deserialize reference without bean factory");
            return null;
        }
        if (this.useMemoryCache && (ret = serializedObjects.remove(this.id)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed a serialized reference. serialized objects size [" + serializedObjects.size() + "]"));
            }
            return this.getSerializableProxy(ret);
        }
        if (this.targetBeanName != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolving serializable object to bean name [" + this.targetBeanName + "]"));
            }
            return this.getSerializableProxy();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving serializable object for [" + this.descriptor.getDependencyName() + "]"));
        }
        Field field = this.descriptor.getField();
        BeanDefinition rbd = this.beanFactory.getBeanDefinition(this.beanName);
        MutablePropertyValues pvs = rbd.getPropertyValues();
        if (pvs.contains(field.getName()) && (value = pvs.getPropertyValue(field.getName())) instanceof BeanReference) {
            this.targetBeanName = ((BeanReference)value).getBeanName();
            return this.getSerializableProxy();
        }
        try {
            Object bean = this.beanFactory.resolveDependency(this.descriptor, this.beanName);
            if (bean != null) {
                return this.getSerializableProxy(bean);
            }
        }
        catch (BeansException bean) {
            // empty catch block
        }
        if (field.isAnnotationPresent(Resource.class)) {
            String name;
            Resource r = field.getAnnotation(Resource.class);
            String string = name = StringUtils.isEmpty((Object)r.name()) ? this.descriptor.getField().getName() : r.name();
            if (this.beanFactory.containsBean(name)) {
                this.targetBeanName = name;
                return this.getSerializableProxy();
            }
        }
        String[] dependentBeans = this.beanFactory.getDependenciesForBean(this.beanName);
        ArrayList<String> candidates = new ArrayList<String>();
        String[] stringArray = dependentBeans;
        int n = dependentBeans.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (this.beanFactory.isTypeMatch(name, this.descriptor.getDependencyType())) {
                // empty if block
            }
            candidates.add(name);
            ++n2;
        }
        if (candidates.size() == 1) {
            return this.getSerializableProxy(this.beanFactory.getBean((String)candidates.get(0)));
        }
        if (candidates.size() > 1) {
            stringArray = pvs.getPropertyValues();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                BeanReference br;
                String pv = stringArray[n2];
                if (pv.getValue() instanceof BeanReference && candidates.contains((br = (BeanReference)pv.getValue()).getBeanName())) {
                    return this.getSerializableProxy(this.beanFactory.getBean(br.getBeanName()));
                }
                ++n2;
            }
        }
        log.error((Object)("Cant not resolve serializable reference wiht candidates " + candidates.toArray()));
        return null;
    }

    protected Object getSerializableProxy(Object targetObject) {
        if (this.targetBeanName != null) {
            return this.getSerializableProxy();
        }
        return SerializableProxyUtils.createSerializableProxy(targetObject, this.proxyTargetClass, this.useMemoryCache, this.beanFactory, this.descriptor, this.beanName);
    }

    protected Object getSerializableProxy() {
        return SerializableProxyUtils.createSerializableProxy(this.beanFactory.getBean(this.targetBeanName), this.proxyTargetClass, this.useMemoryCache, this.beanFactory, this.targetBeanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setTargetBeanName(String name) {
        this.targetBeanName = name;
    }

    public boolean isProxyTargetClass() {
        return this.proxyTargetClass;
    }

    public void setProxyTargetClass(boolean proxyTargetClass) {
        this.proxyTargetClass = proxyTargetClass;
    }

    public boolean isUseMemoryCache() {
        return this.useMemoryCache;
    }

    public void setUseMemoryCache(boolean useMemoryCache) {
        this.useMemoryCache = useMemoryCache;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

