/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.aop;

import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.aop.SerializableAopProxy;
import org.jdal.aop.SerializableIntroductionInterceptor;
import org.jdal.aop.SerializableObject;
import org.jdal.aop.SerializableReference;
import org.jdal.aop.config.SerializableProxyFactoryBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class SerializableProxyUtils {
    public static Log log = LogFactory.getLog(SerializableProxyUtils.class);
    public static final String TARGET_NAME_PREFIX = "jdalSerializableProxy.";

    public static BeanDefinitionHolder createSerializableProxy(BeanDefinitionHolder definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        String originalBeanName = definition.getBeanName();
        BeanDefinition targetDefinition = definition.getBeanDefinition();
        RootBeanDefinition proxyDefinition = new RootBeanDefinition(SerializableProxyFactoryBean.class);
        proxyDefinition.setOriginatingBeanDefinition(definition.getBeanDefinition());
        proxyDefinition.setSource(definition.getSource());
        proxyDefinition.setRole(2);
        String targetBeanName = SerializableProxyUtils.getTargetBeanName(originalBeanName);
        proxyDefinition.getPropertyValues().add("targetBeanName", (Object)targetBeanName);
        if (proxyTargetClass) {
            targetDefinition.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
        } else {
            proxyDefinition.getPropertyValues().add("proxyTargetClass", (Object)Boolean.FALSE);
        }
        proxyDefinition.setAutowireCandidate(targetDefinition.isAutowireCandidate());
        proxyDefinition.setPrimary(targetDefinition.isPrimary());
        if (targetDefinition instanceof AbstractBeanDefinition) {
            proxyDefinition.copyQualifiersFrom((AbstractBeanDefinition)targetDefinition);
        }
        proxyDefinition.getPropertyValues().add("singleton", (Object)(!targetDefinition.isPrototype() ? 1 : 0));
        targetDefinition.setAutowireCandidate(false);
        targetDefinition.setPrimary(false);
        registry.registerBeanDefinition(targetBeanName, targetDefinition);
        return new BeanDefinitionHolder((BeanDefinition)proxyDefinition, originalBeanName, definition.getAliases());
    }

    public static String getTargetBeanName(String originalBeanName) {
        return TARGET_NAME_PREFIX + originalBeanName;
    }

    public static Object createSerializableProxy(Object target, boolean proxyTargetClass, boolean useMemoryCache, ConfigurableListableBeanFactory beanFactory, DependencyDescriptor descriptor, String beanName) {
        if (target instanceof SerializableAopProxy) {
            return target;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating serializable proxy for [" + descriptor.getDependencyName() + "]" + " in bean [" + beanName + "]"));
        }
        SerializableReference reference = new SerializableReference(target, proxyTargetClass, useMemoryCache, beanFactory, descriptor, beanName);
        return SerializableProxyUtils.createSerializableProxy(target, reference);
    }

    public static Object createSerializableProxy(Object target, boolean proxyTargetClass, boolean useMemoryCache, ConfigurableListableBeanFactory beanFactory, String targetBeanName) {
        if (target instanceof SerializableAopProxy) {
            return target;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating serializable proxy for target bean [" + targetBeanName + "]"));
        }
        SerializableReference reference = new SerializableReference(target, proxyTargetClass, useMemoryCache, beanFactory, targetBeanName);
        return SerializableProxyUtils.createSerializableProxy(target, reference);
    }

    public static Object createCachedSerializableProxy(Object target) {
        return SerializableProxyUtils.createSerializableProxy(target, true, true, null, null);
    }

    public static Object createSerializableProxy(Object target, ConfigurableListableBeanFactory beanFactory, String targetBeanName) {
        return SerializableProxyUtils.createSerializableProxy(target, false, false, beanFactory, targetBeanName);
    }

    private static Object createSerializableProxy(Object target, SerializableReference reference) {
        ProxyFactory pf = new ProxyFactory(target);
        pf.setExposeProxy(true);
        pf.setProxyTargetClass(reference.isProxyTargetClass());
        pf.addInterface(SerializableObject.class);
        pf.addAdvice((Advice)new SerializableIntroductionInterceptor(reference));
        return pf.getProxy(reference.getBeanFactory().getBeanClassLoader());
    }
}

