/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.aop;

import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.annotation.SerializableProxy;
import org.jdal.aop.SerializableAopProxy;
import org.jdal.aop.SerializableIntroductionInterceptor;
import org.jdal.aop.SerializableReference;
import org.springframework.aop.framework.autoproxy.ProxyCreationContext;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class SerializableProxyAdvisor
extends DefaultIntroductionAdvisor
implements BeanFactoryAware {
    private static final Log log = LogFactory.getLog(SerializableProxyAdvisor.class);
    private ConfigurableListableBeanFactory beanFactory;

    public SerializableProxyAdvisor() {
        super((Advice)new SerializableIntroductionInterceptor());
    }

    public boolean matches(Class<?> clazz) {
        String beanName;
        SerializableProxy ann = (SerializableProxy)AnnotationUtils.findAnnotation(clazz, SerializableProxy.class);
        if (ann != null && !SerializableAopProxy.class.isAssignableFrom(clazz) && (beanName = ProxyCreationContext.getCurrentProxiedBeanName()) != null && !beanName.startsWith("jdalSerializableProxy.")) {
            this.configureReference(ann, beanName);
            return true;
        }
        return false;
    }

    private void configureReference(SerializableProxy ann, String beanName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring serializable reference for bean [" + beanName + "]"));
        }
        SerializableIntroductionInterceptor advice = (SerializableIntroductionInterceptor)this.getAdvice();
        SerializableReference reference = advice.getReference();
        reference.setTargetBeanName(beanName);
        reference.setBeanFactory(this.beanFactory);
        reference.setProxyTargetClass(ann.proxyTargetClass());
        reference.setUseMemoryCache(ann.useCache());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

