/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.aop;

import java.io.Serializable;
import org.springframework.aop.TargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;

public class DependencyDescriptorTargetSource
implements TargetSource,
BeanFactoryAware,
Serializable {
    private transient Object target;
    private DependencyDescriptor descriptor;
    private String beanName;
    private AutowireCapableBeanFactory beanFactory;

    public DependencyDescriptorTargetSource(DependencyDescriptor descriptor, AutowireCapableBeanFactory beanFactory, String beanName) {
        this.descriptor = descriptor;
        this.beanName = beanName;
        this.beanFactory = beanFactory;
    }

    public Object getTarget() throws Exception {
        if (this.target == null) {
            this.target = this.resolveDependency();
        }
        return this.target;
    }

    protected Object resolveDependency() {
        return this.beanFactory.resolveDependency(this.descriptor, this.beanName);
    }

    public AutowireCapableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public boolean isStatic() {
        return true;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = this.beanFactory;
    }

    public Class<?> getTargetClass() {
        return this.descriptor.getDependencyType();
    }

    public void releaseTarget(Object target) throws Exception {
    }
}

